// SPDX-License-Identifier: GPL-3.0-or-later

// This file defines the nomacs version number.
// It is updated by versionupdate.py (if enabled in CMAKE)
// In addition to the version number displayed in the help section,
// it will update the VS_VERSION_INFO in the *.rc file.

#ifndef DK_VERSION_H
#define DK_VERSION_H

#define NOMACS_VERSION_STR "3.22.0"
#define NOMACS_VER_MAJOR 3
#define NOMACS_VER_MINOR 22
#define NOMACS_VER_PATCH 0

#define NOMACS_VERSION_RC 3,22,0

// we don't do "cmake --install" on Windows which is only where these make sense
#ifndef Q_OS_WIN

// install path of shared libs and plugins
#define NOMACS_INSTALL_LIBPATH "/usr/lib"

// install path of themes and translations
#define NOMACS_INSTALL_DATAPATH "/usr/share"

#endif

// compile-time revision of nomacs
#define NOMACS_REVISION_STR "fec5219c, 2025-12-28"

namespace nmc
{
// run-time revision of nomacs
extern char const * const revisionString;
}

#endif
