/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTree;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeState;

public class TmmTreeModel<E extends TmmTreeNode>
extends DefaultTreeModel {
    protected static final long TIMER_DELAY = 100L;
    protected final TmmTreeDataProvider<E> dataProvider;
    protected final TmmTree<E> tree;
    protected E rootNode = null;
    protected final Map<Object, E> nodeCache = new HashMap<Object, E>();
    protected final Map<Object, Boolean> nodeCached = new HashMap<Object, Boolean>();
    protected final Map<Object, List<E>> rawNodeChildrenCache = new HashMap<Object, List<E>>();
    protected final Map<String, List<E>> filteredNodeChildrenCache = new HashMap<String, List<E>>();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected boolean isAdjusting = false;
    protected long nextUpdateSortAndFilter = 0L;
    protected DelayedUpdateTask updateSortAndFilterTask;
    protected long nextNodeStructureChanged = 0L;
    protected DelayedUpdateTask nodeStructureChangedTask;

    public TmmTreeModel(TmmTree<E> tree, TmmTreeDataProvider<E> dataProvider) {
        super(null);
        this.tree = tree;
        this.dataProvider = dataProvider;
        if (dataProvider.getTreeFilters() == null) {
            this.dataProvider.setTreeFilters(new HashSet());
        }
        dataProvider.addPropertyChangeListener(evt -> {
            TmmTreeNode child;
            if ("nodeInserted".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TmmTreeNode) {
                child = (TmmTreeNode)evt.getNewValue();
                TmmTreeNode parent = dataProvider.getParent(child);
                if (child.getParent() == null) {
                    this.addChildNode(parent, child);
                }
            }
            if ("nodeRemoved".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TmmTreeNode) {
                child = (TmmTreeNode)evt.getNewValue();
                this.removeChildNode(child);
            }
            if ("nodeChanged".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TmmTreeNode) {
                child = (TmmTreeNode)evt.getNewValue();
                this.nodeChanged(child);
                TreeNode[] path = child.getPath();
                if (path != null && path.length > 1) {
                    this.readWriteLock.writeLock().lock();
                    for (int i = 1; i < path.length; ++i) {
                        TmmTreeNode parent = (TmmTreeNode)path[i];
                        this.filteredNodeChildrenCache.remove(parent.getId());
                    }
                    this.readWriteLock.writeLock().unlock();
                    this.updateSortingAndFiltering();
                }
            }
            if ("nodeStructureChanged".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TmmTreeNode) {
                this.nodeStructureChanged();
            }
        });
        this.loadTreeData(this.getRoot());
    }

    public TmmTreeDataProvider<E> getDataProvider() {
        return this.dataProvider;
    }

    protected void loadTreeData(E node) {
        this.getChildCount(node);
    }

    public E getRoot() {
        if (this.rootNode == null) {
            this.rootNode = this.dataProvider.getRoot();
            this.cacheNode(this.rootNode);
        }
        return this.rootNode;
    }

    @Override
    public int getChildCount(Object parent) {
        TmmTreeNode node = (TmmTreeNode)parent;
        if (this.isLeaf(node)) {
            return 0;
        }
        if (this.areChildrenLoaded(node)) {
            return super.getChildCount(parent);
        }
        return this.loadChildren(node);
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.dataProvider.isLeaf((TmmTreeNode)node);
    }

    protected int loadChildren(E parent) {
        List<E> children = this.dataProvider.getChildren(parent);
        this.readWriteLock.writeLock().lock();
        this.rawNodeChildrenCache.put(((TmmTreeNode)parent).getId(), children);
        this.cacheNodes(children);
        this.readWriteLock.writeLock().unlock();
        List<E> realChildren = this.filterAndSort(parent, children);
        this.readWriteLock.writeLock().lock();
        this.nodeCached.put(((TmmTreeNode)parent).getId(), true);
        this.readWriteLock.writeLock().unlock();
        if (realChildren != null && !realChildren.isEmpty()) {
            this.insertNodesInto(realChildren, parent, 0);
        }
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    public void invalidateFilterCache() {
        this.filteredNodeChildrenCache.clear();
    }

    public void updateSortingAndFiltering() {
        this.updateSortingAndFiltering(this.getRoot());
    }

    public void updateSortingAndFiltering(E parent) {
        long now = System.currentTimeMillis();
        if (now > this.nextUpdateSortAndFilter) {
            TmmTreeState treeState = null;
            if (this.tree != null) {
                treeState = this.tree.getTreeState();
            }
            this.setAdjusting(true);
            this.performFilteringAndSortingRecursively(parent);
            this.setAdjusting(false);
            this.nodeStructureChanged(treeState);
            long end = System.currentTimeMillis();
            this.nextUpdateSortAndFilter = end - now < 100L ? end + 100L : end + (end - now) * 2L;
        } else {
            this.startUpdateSortAndFilterTimer();
        }
    }

    protected void startUpdateSortAndFilterTimer() {
        if (this.updateSortAndFilterTask != null) {
            this.updateSortAndFilterTask.updateNeeded = true;
            return;
        }
        Timer updateSortAndFilterTimer = new Timer();
        this.updateSortAndFilterTask = new DelayedUpdateTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> {
                    TmmTreeModel.this.updateSortingAndFiltering();
                    TmmTreeModel.this.updateSortAndFilterTask = null;
                    if (this.updateNeeded) {
                        TmmTreeModel.this.startUpdateSortAndFilterTimer();
                    }
                });
            }
        };
        updateSortAndFilterTimer.schedule((TimerTask)this.updateSortAndFilterTask, 100L);
    }

    protected boolean hasActiveFilters() {
        if (this.dataProvider.getTreeFilters() == null || !this.dataProvider.isFiltersActive()) {
            return false;
        }
        for (ITmmTreeFilter<E> filter : this.dataProvider.getTreeFilters()) {
            if (!filter.isActive()) continue;
            return true;
        }
        return false;
    }

    public void nodeStructureChanged() {
        this.nodeStructureChanged((TmmTreeState)null);
    }

    public void nodeStructureChanged(TmmTreeState treeState) {
        long now = System.currentTimeMillis();
        if (now > this.nextNodeStructureChanged) {
            long end;
            this.nodeStructureChanged((TreeNode)this.getRoot());
            if (treeState != null && this.tree != null) {
                this.tree.setTreeState(treeState);
            }
            this.nextNodeStructureChanged = (end = System.currentTimeMillis()) - now < 100L ? end + 100L : end + (end - now) * 2L;
        } else {
            this.startNodeStructureChangedTimer(treeState);
        }
    }

    protected void startNodeStructureChangedTimer(final TmmTreeState treeState) {
        if (this.nodeStructureChangedTask != null) {
            this.nodeStructureChangedTask.updateNeeded = true;
            return;
        }
        Timer nodeStructureChangedTimer = new Timer();
        this.nodeStructureChangedTask = new DelayedUpdateTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> {
                    TmmTreeModel.this.nodeStructureChanged((TreeNode)TmmTreeModel.this.getRoot());
                    if (treeState != null && TmmTreeModel.this.tree != null) {
                        TmmTreeModel.this.tree.setTreeState(treeState);
                    }
                    TmmTreeModel.this.nodeStructureChangedTask = null;
                    if (this.updateNeeded) {
                        TmmTreeModel.this.startNodeStructureChangedTimer(treeState);
                    }
                });
            }
        };
        nodeStructureChangedTimer.schedule((TimerTask)this.nodeStructureChangedTask, 100L);
    }

    protected boolean performFilteringAndSortingRecursively(E parentNode) {
        boolean nodesChanged = false;
        nodesChanged = this.performFilteringAndSorting(parentNode) || nodesChanged;
        for (int i = 0; i < ((DefaultMutableTreeNode)parentNode).getChildCount(); ++i) {
            nodesChanged = this.performFilteringAndSortingRecursively((TmmTreeNode)((DefaultMutableTreeNode)parentNode).getChildAt(i)) || nodesChanged;
        }
        return nodesChanged;
    }

    protected boolean performFilteringAndSorting(E parentNode) {
        boolean nodesChanged = false;
        List<E> children = this.rawNodeChildrenCache.get(((TmmTreeNode)parentNode).getId());
        List<E> oldChildren = this.getChildren(parentNode);
        List<E> newChildren = this.filterAndSort(parentNode, children);
        if (children != null && !oldChildren.equals(newChildren)) {
            nodesChanged = true;
            ((DefaultMutableTreeNode)parentNode).removeAllChildren();
            List<E> realChildren = this.filterAndSort(parentNode, children);
            for (TmmTreeNode child : realChildren) {
                ((DefaultMutableTreeNode)parentNode).add(child);
            }
        }
        return nodesChanged;
    }

    private List<E> getChildren(E parent) {
        ArrayList<TmmTreeNode> children = new ArrayList<TmmTreeNode>();
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)parent).children();
        while (e.hasMoreElements()) {
            children.add((TmmTreeNode)e.nextElement());
        }
        return children;
    }

    private List<E> getChildrenRecursive(E parent) {
        ArrayList<TmmTreeNode> children = new ArrayList<TmmTreeNode>();
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)parent).children();
        while (e.hasMoreElements()) {
            TmmTreeNode child = (TmmTreeNode)e.nextElement();
            children.add(child);
            if (child.getChildCount() <= 0) continue;
            children.addAll(this.getChildrenRecursive(child));
        }
        return children;
    }

    protected List<E> filterAndSort(E parentNode, List<E> children) {
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        this.readWriteLock.readLock().lock();
        List<E> filteredNodes = this.filteredNodeChildrenCache.get(((TmmTreeNode)parentNode).getId());
        this.readWriteLock.readLock().unlock();
        if (filteredNodes != null) {
            return filteredNodes;
        }
        ArrayList<TmmTreeNode> filteredAndSorted = new ArrayList<TmmTreeNode>();
        if (this.hasActiveFilters()) {
            Set<ITmmTreeFilter<E>> filters = this.dataProvider.getTreeFilters();
            for (TmmTreeNode element : new ArrayList<E>(children)) {
                boolean accepted = true;
                for (ITmmTreeFilter<TmmTreeNode> iTmmTreeFilter : filters) {
                    if (iTmmTreeFilter.accept(element)) continue;
                    accepted = false;
                }
                if (!accepted) continue;
                filteredAndSorted.add(element);
            }
        } else {
            filteredAndSorted.addAll(children);
        }
        Comparator<E> comparator = this.dataProvider.getTreeComparator();
        if (comparator != null) {
            try {
                filteredAndSorted.sort(comparator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.readWriteLock.writeLock().lock();
        this.filteredNodeChildrenCache.put(((TmmTreeNode)parentNode).getId(), filteredAndSorted);
        this.readWriteLock.writeLock().unlock();
        return filteredAndSorted;
    }

    public void addChildNode(E parent, E child) {
        if (child == null || parent == null) {
            return;
        }
        this.addChildNodes(parent, Collections.singletonList(child));
    }

    public void addChildNodes(E parent, List<E> children) {
        if (children == null || children.isEmpty() || parent == null) {
            return;
        }
        this.setAdjusting(true);
        this.readWriteLock.writeLock().lock();
        List<E> cachedChildren = this.rawNodeChildrenCache.get(((TmmTreeNode)parent).getId());
        if (cachedChildren == null) {
            cachedChildren = new ArrayList(children.size());
            this.rawNodeChildrenCache.put(((TmmTreeNode)parent).getId(), cachedChildren);
        }
        cachedChildren.addAll(children);
        this.cacheNodes(children);
        for (TreeNode obj : ((DefaultMutableTreeNode)parent).getPath()) {
            if (!(obj instanceof TmmTreeNode)) continue;
            this.filteredNodeChildrenCache.remove(((TmmTreeNode)obj).getId());
        }
        this.filteredNodeChildrenCache.remove(((TmmTreeNode)this.getRoot()).getId());
        this.readWriteLock.writeLock().unlock();
        this.clearNodeChildrenCache(children, false);
        this.insertNodesInto(children, parent, ((DefaultMutableTreeNode)parent).getChildCount());
        this.setAdjusting(false);
        this.updateSortingAndFiltering();
    }

    public void removeChildNode(E node) {
        if (node == null) {
            return;
        }
        this.setAdjusting(true);
        TmmTreeNode parent = (TmmTreeNode)((DefaultMutableTreeNode)node).getParent();
        if (parent == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        List<E> children = this.rawNodeChildrenCache.get(parent.getId());
        if (children != null) {
            children.remove(node);
        }
        for (TmmTreeNode child : this.getChildrenRecursive(node)) {
            this.filteredNodeChildrenCache.remove(child.getId());
        }
        for (TreeNode obj : parent.getPath()) {
            if (!(obj instanceof TmmTreeNode)) continue;
            this.filteredNodeChildrenCache.remove(((TmmTreeNode)obj).getId());
        }
        this.filteredNodeChildrenCache.remove(((TmmTreeNode)this.getRoot()).getId());
        this.readWriteLock.writeLock().unlock();
        this.clearNodeChildrenCache(node, true);
        ((DefaultMutableTreeNode)node).removeAllChildren();
        super.removeNodeFromParent((MutableTreeNode)node);
        this.setAdjusting(false);
        this.updateSortingAndFiltering();
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        this.removeChildNode((TmmTreeNode)node);
    }

    protected void insertNodeIntoImpl(E child, E parent, int index) {
        super.insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
        this.loadTreeData(child);
    }

    public void insertNodesInto(List<E> children, E parent, int index) {
        for (int i = children.size() - 1; i >= 0; --i) {
            ((DefaultMutableTreeNode)parent).insert((MutableTreeNode)children.get(i), index);
        }
        int[] indices = new int[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            indices[i] = index + i;
        }
        try {
            this.nodesWereInserted((TreeNode)parent, indices);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (TmmTreeNode child : children) {
            this.loadTreeData(child);
        }
    }

    public void insertNodesInto(E[] children, E parent, int index) {
        for (int i = children.length - 1; i >= 0; --i) {
            ((DefaultMutableTreeNode)parent).insert((MutableTreeNode)children[i], index);
        }
        int[] indices = new int[children.length];
        for (int i = 0; i < children.length; ++i) {
            indices[i] = index + i;
        }
        this.nodesWereInserted((TreeNode)parent, indices);
        for (E child : children) {
            this.loadTreeData(child);
        }
    }

    protected void clearNodeChildrenCache(E node, boolean clearNode) {
        this.readWriteLock.writeLock().lock();
        if (clearNode) {
            this.nodeCache.remove(((TmmTreeNode)node).getId());
        }
        this.nodeCached.remove(((TmmTreeNode)node).getId());
        List<E> children = this.rawNodeChildrenCache.remove(((TmmTreeNode)node).getId());
        this.readWriteLock.writeLock().unlock();
        if (children != null) {
            this.clearNodeChildrenCache(children, true);
        }
    }

    protected void clearNodeChildrenCache(List<E> nodes, boolean clearNodes) {
        for (TmmTreeNode node : nodes) {
            this.clearNodeChildrenCache(node, clearNodes);
        }
    }

    protected void clearNodeChildrenCache(E[] nodes, boolean clearNodes) {
        for (E node : nodes) {
            this.clearNodeChildrenCache(node, clearNodes);
        }
    }

    protected void cacheNode(E node) {
        this.readWriteLock.writeLock().lock();
        this.nodeCache.put(((TmmTreeNode)node).getId(), node);
        this.readWriteLock.writeLock().unlock();
    }

    protected void cacheNodes(List<E> nodes) {
        this.readWriteLock.writeLock().lock();
        for (TmmTreeNode node : nodes) {
            this.nodeCache.put(node.getId(), node);
        }
        this.readWriteLock.writeLock().unlock();
    }

    protected boolean areChildrenLoaded(E node) {
        this.readWriteLock.readLock().lock();
        Boolean cached = this.nodeCached.get(((TmmTreeNode)node).getId());
        this.readWriteLock.readLock().unlock();
        return cached != null && cached != false;
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void setAdjusting(boolean adjusting) {
        this.isAdjusting = adjusting;
    }

    public static abstract class DelayedUpdateTask
    extends TimerTask {
        boolean updateNeeded = false;
    }
}

