/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5;

public class TraktLink {
    private static final String URL_MOVIE = "https://trakt.tv/movies/";
    private static final String URL_SHOW = "https://trakt.tv/shows/";
    private static final String URL_SEASON = "https://trakt.tv/seasons/";
    private static final String URL_EPISODE = "https://trakt.tv/episodes/";
    private static final String URL_PERSON = "https://trakt.tv/people/";
    private static final String URL_COMMENT = "https://trakt.tv/comments/";
    private static final String URL_IMDB = "https://trakt.tv/search/imdb/";
    private static final String URL_TMDB = "https://trakt.tv/search/tmdb/";
    private static final String URL_TVDB = "https://trakt.tv/search/tvdb/";
    @Deprecated
    private static final String URL_TVRAGE = "https://trakt.tv/search/tvrage/";
    private static final String PATH_SEASONS = "/seasons/";
    private static final String PATH_EPISODES = "/episodes/";

    public static String movie(String idOrSlug) {
        return URL_MOVIE + idOrSlug;
    }

    public static String show(String idOrSlug) {
        return URL_SHOW + idOrSlug;
    }

    public static String season(int id) {
        return URL_SEASON + id;
    }

    public static String season(int showId, int season) {
        return TraktLink.show(String.valueOf(showId)) + PATH_SEASONS + season;
    }

    public static String episode(int id) {
        return URL_EPISODE + id;
    }

    public static String episode(int showId, int season, int episode) {
        return TraktLink.show(String.valueOf(showId)) + PATH_SEASONS + season + PATH_EPISODES + episode;
    }

    public static String person(String idOrSlug) {
        return URL_PERSON + idOrSlug;
    }

    public static String comment(int id) {
        return URL_COMMENT + id;
    }

    public static String imdb(String imdbId) {
        return URL_IMDB + imdbId;
    }

    public static String tmdb(int tmdbId) {
        return URL_TMDB + tmdbId;
    }

    public static String tvdb(int tvdbId) {
        return URL_TVDB + tvdbId;
    }

    @Deprecated
    public static String tvrage(int tvrageId) {
        return URL_TVRAGE + tvrageId;
    }
}

