/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetArtworkProvider;
import org.tinymediamanager.scraper.tmdb.TmdbArtworkProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;

public class TmdbMovieArtworkProvider
extends TmdbMetadataProvider
implements IMovieArtworkProvider,
IMovieSetArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbMovieArtworkProvider.class);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "movie_artwork";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getArtwork(): {}", (Object)options);
        this.initAPI();
        if (options.getMediaType() != MediaType.MOVIE_SET && options.getMediaType() != MediaType.MOVIE) {
            return Collections.emptyList();
        }
        return new TmdbArtworkProvider(this.api, this.artworkBaseUrl).getArtwork(options);
    }
}

