/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.grammar;

import java.util.Iterator;
import lombok.Generated;
import lombok.NonNull;
import org.vinniks.parsla.grammar.Item;
import org.vinniks.parsla.util.Validations;

public final class Option {
    private final String ruleName;
    private final boolean output;
    private final Iterable<Item> items;

    public Option(@NonNull String ruleName, boolean output, @NonNull Iterable<Item> items) {
        if (ruleName == null) {
            throw new NullPointerException("ruleName is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        Validations.requireNonNullElements(items, "option item can not be null");
        this.ruleName = ruleName;
        this.output = output;
        this.items = items;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Option) {
            Option otherOption = (Option)other;
            if (!this.ruleName.equals(otherOption.ruleName) || this.output != otherOption.output) {
                return false;
            }
            Iterator<Item> itemIterator = this.items.iterator();
            Iterator<Item> otherItemIterator = otherOption.items.iterator();
            while (itemIterator.hasNext() && otherItemIterator.hasNext()) {
                if (itemIterator.next().equals(otherItemIterator.next())) continue;
                return false;
            }
            return !itemIterator.hasNext() && !otherItemIterator.hasNext();
        }
        return false;
    }

    @Generated
    public String getRuleName() {
        return this.ruleName;
    }

    @Generated
    public boolean isOutput() {
        return this.output;
    }

    @Generated
    public Iterable<Item> getItems() {
        return this.items;
    }
}

