/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.ext;

import com.fasterxml.uuid.TimestampSynchronizer;
import com.fasterxml.uuid.ext.LockedFile;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedTimestampSynchronizer
extends TimestampSynchronizer {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedTimestampSynchronizer.class);
    static final long DEFAULT_UPDATE_INTERVAL = 10000L;
    protected static final String DEFAULT_LOCK_FILE_NAME1 = "uuid1.lck";
    protected static final String DEFAULT_LOCK_FILE_NAME2 = "uuid2.lck";
    protected long mInterval = 10000L;
    protected final LockedFile mLocked1;
    protected final LockedFile mLocked2;
    boolean mFirstActive = false;

    public FileBasedTimestampSynchronizer() throws IOException {
        this(new File(DEFAULT_LOCK_FILE_NAME1), new File(DEFAULT_LOCK_FILE_NAME2));
    }

    public FileBasedTimestampSynchronizer(File lockFile1, File lockFile2) throws IOException {
        this(lockFile1, lockFile2, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedTimestampSynchronizer(File lockFile1, File lockFile2, long interval) throws IOException {
        this.mInterval = interval;
        this.mLocked1 = new LockedFile(lockFile1);
        boolean ok = false;
        try {
            this.mLocked2 = new LockedFile(lockFile2);
            ok = true;
        }
        finally {
            if (!ok) {
                this.mLocked1.deactivate();
            }
        }
    }

    public void setUpdateInterval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("Illegal value (" + interval + "); has to be a positive integer value");
        }
        this.mInterval = interval;
    }

    @Override
    protected long initialize() throws IOException {
        long result;
        long ts2;
        long ts1 = this.mLocked1.readStamp();
        if (ts1 > (ts2 = this.mLocked2.readStamp())) {
            this.mFirstActive = true;
            result = ts1;
        } else {
            this.mFirstActive = false;
            result = ts2;
        }
        if (result <= 0L) {
            logger.warn("Could not determine safe timer starting point: assuming current system time is acceptable");
        } else {
            long now = System.currentTimeMillis();
            if (now + this.mInterval < result) {
                logger.warn("Safe timestamp read is {} milliseconds in future, and is greater than the inteval ({})", (Object)(result - now), (Object)this.mInterval);
            }
        }
        return result;
    }

    @Override
    public void deactivate() throws IOException {
        FileBasedTimestampSynchronizer.doDeactivate(this.mLocked1, this.mLocked2);
    }

    @Override
    public long update(long now) throws IOException {
        long nextAllowed = now + this.mInterval;
        if (this.mFirstActive) {
            this.mLocked2.writeStamp(nextAllowed);
        } else {
            this.mLocked1.writeStamp(nextAllowed);
        }
        this.mFirstActive = !this.mFirstActive;
        return nextAllowed;
    }

    protected static void doDeactivate(LockedFile lf1, LockedFile lf2) {
        if (lf1 != null) {
            lf1.deactivate();
        }
        if (lf2 != null) {
            lf2.deactivate();
        }
    }
}

