/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.dashboard.ImmutableWifiActivityStatDto;
import com.ubnt.return.C;
import org.immutables.value.Value;

@Value.Immutable
@C
public interface WifiActivityStatDto {
    @JsonProperty(value="timestamp")
    public long timestamp();

    @JsonProperty(value="num_sta")
    public int clientCount();

    @JsonProperty(value="tx_retry_percentage")
    public double transmissionRetryPercentage();

    @JsonProperty(value="max_tx_retry_percentage")
    public double maxTransmissionRetryPercentage();

    @JsonProperty(value="tx_byte-r")
    public long txByteRate();

    @JsonProperty(value="rx_byte-r")
    public long rxByteRate();

    @JsonIgnore
    @Value.Auxiliary
    public long rxBytes();

    @JsonIgnore
    @Value.Auxiliary
    public long txBytes();

    default public boolean hasStats() {
        return this.clientCount() != 0;
    }

    public static ImmutableWifiActivityStatDto.Builder builder() {
        return ImmutableWifiActivityStatDto.builder();
    }

    public static WifiActivityStatDto empty(long l2) {
        return ImmutableWifiActivityStatDto.builder().timestamp(l2).rxByteRate(0L).txByteRate(0L).clientCount(0).transmissionRetryPercentage(0.0).maxTransmissionRetryPercentage(0.0).txBytes(0L).rxBytes(0L).build();
    }
}

