/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.wifi.validator;

import com.ubnt.C.A.E;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.PrivatePreSharedKey;
import com.ubnt.data.WlanConf;
import com.ubnt.model.api.radius.RadiusProfileDto;
import com.ubnt.service.network.configuration.repository.B;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.template.wifi.validator.MdnsProxyWarningValidator;
import com.ubnt.service.orchestration.template.wifi.validator.WifiOrchestrationWarning;
import com.ubnt.service.radius.OOoO;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WifiTemplateWarningValidator {
    private final B networkConfigCrudService;
    private final OOoO radiusProfilesCrudService;
    private final MdnsProxyWarningValidator mdnsProxyWarningValidator;

    public List<IssueDetailReportDto> checkTemplateForWarnings(List<WlanConf> list) {
        return list.stream().flatMap(wlanConf -> this.if((WlanConf)wlanConf).stream()).toList();
    }

    private List<IssueDetailReportDto> if(WlanConf wlanConf) {
        E e2 = E.\u00d300000();
        this.\u00f500000(wlanConf, (E<IssueDetailReportDto>)e2);
        this.\u00f400000(wlanConf, (E<IssueDetailReportDto>)e2);
        this.\u00f800000(wlanConf, (E<IssueDetailReportDto>)e2);
        List<IssueDetailReportDto> list = this.mdnsProxyWarningValidator.\u00d800000(wlanConf);
        return e2.\u00d200000(list).super();
    }

    private void \u00f500000(WlanConf wlanConf, E<IssueDetailReportDto> e2) {
        NetworkConf networkConf = this.networkConfigCrudService.\u00d4O0000(wlanConf.getSiteId());
        if (networkConf != null && StringUtils.equals((CharSequence)networkConf.getId(), (CharSequence)wlanConf.getNetworkConfigurationId())) {
            e2.\u00d400000((Object)IssueDetailReportDto.builder().code(WifiOrchestrationWarning.NO_VLAN_DEFINED).issueDetail("No vlan defined. Defaulting to 'Default' lan.").build());
        }
    }

    private void \u00f400000(WlanConf wlanConf, E<IssueDetailReportDto> e2) {
        List list;
        if (wlanConf.isPrivatePresharedKeysEnabled() && !(list = wlanConf.getPrivatePreSharedKeys().stream().filter(privatePreSharedKey -> StringUtils.isEmpty((CharSequence)privatePreSharedKey.networkId())).map(PrivatePreSharedKey::vlanId).flatMap(Optional::stream).toList()).isEmpty()) {
            e2.\u00d400000((Object)IssueDetailReportDto.builder().code(WifiOrchestrationWarning.PPSK_WITHOUT_VLAN).issueDetail("PPSK is enabled but no network configuration exists for vlan_id(s): " + String.valueOf(list)).build());
            List<PrivatePreSharedKey> list2 = wlanConf.getPrivatePreSharedKeys().stream().filter(privatePreSharedKey -> StringUtils.isNotEmpty((CharSequence)privatePreSharedKey.networkId())).toList();
            if (list2.isEmpty()) {
                wlanConf.setPrivatePresharedKeysEnabled(false);
            }
            wlanConf.setPrivatePreSharedKeys(list2);
        }
    }

    private void \u00f800000(WlanConf wlanConf, E<IssueDetailReportDto> e2) {
        if (this.\u00d400000(wlanConf)) {
            List<RadiusProfileDto> list = this.radiusProfilesCrudService.return(wlanConf.getSiteId());
            if (list.isEmpty()) {
                this.new(wlanConf, e2);
            } else if (list.size() > 1) {
                list.stream().filter(radiusProfileDto -> !"Default".equals(radiusProfileDto.hiddenId().orElse(""))).findFirst().ifPresent(radiusProfileDto -> wlanConf.setRadiusProfileId(radiusProfileDto.id()));
            } else {
                wlanConf.setRadiusProfileId(list.get(0).id());
            }
        }
    }

    private boolean \u00d400000(WlanConf wlanConf) {
        return wlanConf.isRadiusMacAuthenticationEnabled() && StringUtils.isEmpty((CharSequence)wlanConf.getRadiusProfileId());
    }

    private void new(WlanConf wlanConf, E<IssueDetailReportDto> e2) {
        RadiusProfileDto radiusProfileDto = this.radiusProfilesCrudService.\u00f400000(wlanConf.getSiteId());
        if (radiusProfileDto != null) {
            wlanConf.setRadiusProfileId(radiusProfileDto.id());
            e2.\u00d400000((Object)IssueDetailReportDto.builder().code(WifiOrchestrationWarning.RADIUS_PROFILE_NOT_FOUND).issueDetail("Radius profile id is not set but default radius profile is defined. Will use default radius profile.").build());
        }
    }

    @ConstructorProperties(value={"networkConfigCrudService", "radiusProfilesCrudService", "mdnsProxyWarningValidator"})
    @Generated
    public WifiTemplateWarningValidator(B b2, OOoO oOoO2, MdnsProxyWarningValidator mdnsProxyWarningValidator) {
        this.networkConfigCrudService = b2;
        this.radiusProfilesCrudService = oOoO2;
        this.mdnsProxyWarningValidator = mdnsProxyWarningValidator;
    }
}

