/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AltererResult;
import io.jenetics.CompositeAlterer;
import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.util.ISeq;
import io.jenetics.util.Seq;
import java.util.Objects;

@FunctionalInterface
public interface Alterer<G extends Gene<?, G>, C extends Comparable<? super C>> {
    public static final double DEFAULT_ALTER_PROBABILITY = 0.2;

    public AltererResult<G, C> alter(Seq<Phenotype<G, C>> var1, long var2);

    default public Alterer<G, C> compose(Alterer<G, C> before) {
        return Alterer.of(before, this);
    }

    default public Alterer<G, C> andThen(Alterer<G, C> after) {
        return Alterer.of(this, Objects.requireNonNull(after));
    }

    @SafeVarargs
    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Alterer<G, C> of(Alterer<G, C> ... alterers) {
        return alterers.length == 0 ? (p, g) -> AltererResult.of(p.asISeq()) : (alterers.length == 1 ? alterers[0] : new CompositeAlterer<G, C>(ISeq.of(alterers)));
    }
}

