/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.util.Seq;
import java.security.AccessController;
import java.util.concurrent.RecursiveAction;

final class RunnablesAction
extends RecursiveAction {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_THRESHOLD = 7;
    private final Seq<? extends Runnable> _runnables;
    private final int _high;
    private final int _low;

    private RunnablesAction(Seq<? extends Runnable> runnables, int low, int high) {
        this._runnables = runnables;
        this._low = low;
        this._high = high;
    }

    public RunnablesAction(Seq<? extends Runnable> runnables) {
        this(runnables, 0, runnables.size());
    }

    @Override
    protected void compute() {
        if (this._high - this._low <= Env.splitThreshold || RunnablesAction.getSurplusQueuedTaskCount() > Env.maxSurplusQueuedTaskCount) {
            for (int i = this._low; i < this._high; ++i) {
                this._runnables.get(i).run();
            }
        } else {
            int mid = this._low + this._high >>> 1;
            RunnablesAction.invokeAll(new RunnablesAction(this._runnables, this._low, mid), new RunnablesAction(this._runnables, mid, this._high));
        }
    }

    private static final class Env {
        private static final int splitThreshold = Math.max(AccessController.doPrivileged(() -> Integer.getInteger("io.jenetics.concurrency.splitThreshold", 5)), 1);
        private static final int maxSurplusQueuedTaskCount = Math.max(AccessController.doPrivileged(() -> Integer.getInteger("io.jenetics.concurrency.maxSurplusQueuedTaskCount", 3)), 1);

        private Env() {
        }
    }
}

