/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.gateway.engine;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.gateway.engine.GatewayEngineUtilizationDataPointDto;
import com.ubnt.model.api.gateway.engine.GatewayEngineUtilizationDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Schema(name="Gateway Engine Utilization")
@Generated(from="GatewayEngineUtilizationDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableGatewayEngineUtilizationDto
implements GatewayEngineUtilizationDto {
    private final double cpuUtilizationPercent;
    private final List<GatewayEngineUtilizationDataPointDto> dataPoints;
    private final double memoryUtilizationPercent;
    private final long memoryUtilizationInBytes;
    private final long memoryTotalInBytes;

    private ImmutableGatewayEngineUtilizationDto(double d2, Iterable<? extends GatewayEngineUtilizationDataPointDto> iterable, double d3, long l2, long l3) {
        this.cpuUtilizationPercent = d2;
        this.dataPoints = ImmutableGatewayEngineUtilizationDto.o00000(false, ImmutableGatewayEngineUtilizationDto.\u00d200000(iterable, false, false));
        this.memoryUtilizationPercent = d3;
        this.memoryUtilizationInBytes = l2;
        this.memoryTotalInBytes = l3;
    }

    private ImmutableGatewayEngineUtilizationDto(Builder builder) {
        this.cpuUtilizationPercent = builder.cpuUtilizationPercent;
        this.dataPoints = ImmutableGatewayEngineUtilizationDto.o00000(true, builder.dataPoints);
        this.memoryUtilizationPercent = builder.memoryUtilizationPercent;
        this.memoryUtilizationInBytes = builder.memoryUtilizationInBytes;
        this.memoryTotalInBytes = builder.memoryTotalInBytes;
    }

    @Override
    public double cpuUtilizationPercent() {
        return this.cpuUtilizationPercent;
    }

    @Override
    public List<GatewayEngineUtilizationDataPointDto> dataPoints() {
        return this.dataPoints;
    }

    @Override
    public double memoryUtilizationPercent() {
        return this.memoryUtilizationPercent;
    }

    @Override
    public long memoryUtilizationInBytes() {
        return this.memoryUtilizationInBytes;
    }

    @Override
    public long memoryTotalInBytes() {
        return this.memoryTotalInBytes;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableGatewayEngineUtilizationDto && this.\u00d300000(0, (ImmutableGatewayEngineUtilizationDto)object);
    }

    private boolean \u00d300000(int n2, ImmutableGatewayEngineUtilizationDto immutableGatewayEngineUtilizationDto) {
        return Double.doubleToLongBits(this.cpuUtilizationPercent) == Double.doubleToLongBits(immutableGatewayEngineUtilizationDto.cpuUtilizationPercent) && this.dataPoints.equals(immutableGatewayEngineUtilizationDto.dataPoints) && Double.doubleToLongBits(this.memoryUtilizationPercent) == Double.doubleToLongBits(immutableGatewayEngineUtilizationDto.memoryUtilizationPercent) && this.memoryUtilizationInBytes == immutableGatewayEngineUtilizationDto.memoryUtilizationInBytes && this.memoryTotalInBytes == immutableGatewayEngineUtilizationDto.memoryTotalInBytes;
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Double.hashCode(this.cpuUtilizationPercent);
        n2 += (n2 << 5) + this.dataPoints.hashCode();
        n2 += (n2 << 5) + Double.hashCode(this.memoryUtilizationPercent);
        n2 += (n2 << 5) + Long.hashCode(this.memoryUtilizationInBytes);
        n2 += (n2 << 5) + Long.hashCode(this.memoryTotalInBytes);
        return n2;
    }

    public String toString() {
        return "GatewayEngineUtilizationDto{cpuUtilizationPercent=" + this.cpuUtilizationPercent + ", dataPoints=" + this.dataPoints + ", memoryUtilizationPercent=" + this.memoryUtilizationPercent + ", memoryUtilizationInBytes=" + this.memoryUtilizationInBytes + ", memoryTotalInBytes=" + this.memoryTotalInBytes + "}";
    }

    public static ImmutableGatewayEngineUtilizationDto of(double d2, List<GatewayEngineUtilizationDataPointDto> list, double d3, long l2, long l3) {
        return ImmutableGatewayEngineUtilizationDto.of(d2, list, d3, l2, l3);
    }

    public static ImmutableGatewayEngineUtilizationDto of(double d2, Iterable<? extends GatewayEngineUtilizationDataPointDto> iterable, double d3, long l2, long l3) {
        return new ImmutableGatewayEngineUtilizationDto(d2, iterable, d3, l2, l3);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> \u00d200000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> o00000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GatewayEngineUtilizationDto", generator="Immutables")
    public static final class Builder {
        private double cpuUtilizationPercent;
        private List<GatewayEngineUtilizationDataPointDto> dataPoints = new ArrayList<GatewayEngineUtilizationDataPointDto>();
        private double memoryUtilizationPercent;
        private long memoryUtilizationInBytes;
        private long memoryTotalInBytes;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GatewayEngineUtilizationDto gatewayEngineUtilizationDto) {
            Objects.requireNonNull(gatewayEngineUtilizationDto, "instance");
            this.cpuUtilizationPercent(gatewayEngineUtilizationDto.cpuUtilizationPercent());
            this.addAllDataPoints(gatewayEngineUtilizationDto.dataPoints());
            this.memoryUtilizationPercent(gatewayEngineUtilizationDto.memoryUtilizationPercent());
            this.memoryUtilizationInBytes(gatewayEngineUtilizationDto.memoryUtilizationInBytes());
            this.memoryTotalInBytes(gatewayEngineUtilizationDto.memoryTotalInBytes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cpuUtilizationPercent(double d2) {
            this.cpuUtilizationPercent = d2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDataPoints(@Nullable GatewayEngineUtilizationDataPointDto gatewayEngineUtilizationDataPointDto) {
            this.dataPoints.add(gatewayEngineUtilizationDataPointDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDataPoints(GatewayEngineUtilizationDataPointDto ... gatewayEngineUtilizationDataPointDtoArray) {
            for (GatewayEngineUtilizationDataPointDto gatewayEngineUtilizationDataPointDto : gatewayEngineUtilizationDataPointDtoArray) {
                this.dataPoints.add(gatewayEngineUtilizationDataPointDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dataPoints(Iterable<? extends GatewayEngineUtilizationDataPointDto> iterable) {
            this.dataPoints.clear();
            return this.addAllDataPoints(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDataPoints(Iterable<? extends GatewayEngineUtilizationDataPointDto> iterable) {
            for (GatewayEngineUtilizationDataPointDto gatewayEngineUtilizationDataPointDto : iterable) {
                this.dataPoints.add(gatewayEngineUtilizationDataPointDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder memoryUtilizationPercent(double d2) {
            this.memoryUtilizationPercent = d2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder memoryUtilizationInBytes(long l2) {
            this.memoryUtilizationInBytes = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder memoryTotalInBytes(long l2) {
            this.memoryTotalInBytes = l2;
            return this;
        }

        public ImmutableGatewayEngineUtilizationDto build() {
            return new ImmutableGatewayEngineUtilizationDto(this);
        }
    }
}

