/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.union;

import cpw.mods.niofs.union.UnionPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.spi.URLStreamHandlerProvider;
import java.nio.file.Path;
import java.nio.file.Paths;

public class UnionURLStreamHandlerProvider
extends URLStreamHandlerProvider {
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if ("union".equals(protocol)) {
            return new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    return new URLConnection(url){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            try {
                                Path path = Paths.get(this.url.toURI());
                                if (path instanceof UnionPath) {
                                    UnionPath upath = (UnionPath)path;
                                    return upath.buildInputStream();
                                }
                                throw new IllegalArgumentException("Invalid Path " + this.url.toURI());
                            }
                            catch (URISyntaxException e) {
                                return (InputStream)UnionURLStreamHandlerProvider.sneak(e);
                            }
                            catch (UncheckedIOException e) {
                                throw e.getCause();
                            }
                        }
                    };
                }
            };
        }
        return null;
    }

    private static <E extends Throwable, R> R sneak(Exception exception) throws E {
        throw exception;
    }
}

