/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class DefaultedMappedRegistry<T>
extends MappedRegistry<T>
implements DefaultedRegistry<T> {
    private final ResourceLocation defaultKey;
    private Holder.Reference<T> defaultValue;

    public DefaultedMappedRegistry(String p_260196_, ResourceKey<? extends Registry<T>> p_259440_, Lifecycle p_260260_, boolean p_259808_) {
        super(p_259440_, p_260260_, p_259808_);
        this.defaultKey = ResourceLocation.parse(p_260196_);
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> p_332872_, T p_328327_, RegistrationInfo p_331941_) {
        Holder.Reference<T> reference = super.register(p_332872_, p_328327_, p_331941_);
        if (this.defaultKey.equals(p_332872_.location())) {
            this.defaultValue = reference;
        }
        return reference;
    }

    @Override
    public int getId(@Nullable T p_260033_) {
        int i = super.getId(p_260033_);
        return i == -1 ? super.getId(this.defaultValue.value()) : i;
    }

    @Override
    @Nonnull
    public ResourceLocation getKey(T p_259233_) {
        ResourceLocation resourcelocation = super.getKey(p_259233_);
        return resourcelocation == null ? this.defaultKey : resourcelocation;
    }

    @Override
    @Nonnull
    public T getValue(@Nullable ResourceLocation p_365640_) {
        Object t = super.getValue(p_365640_);
        return t == null && this.defaultValue != null ? this.defaultValue.value() : t;
    }

    @Override
    public Optional<T> getOptional(@Nullable ResourceLocation p_260078_) {
        return Optional.ofNullable(super.getValue(p_260078_));
    }

    @Override
    public Optional<Holder.Reference<T>> getAny() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    @Nonnull
    public T byId(int p_259534_) {
        Object t = super.byId(p_259534_);
        return t == null ? this.defaultValue.value() : t;
    }

    @Override
    public Optional<Holder.Reference<T>> getRandom(RandomSource p_260255_) {
        return super.getRandom(p_260255_).or(() -> Optional.of(this.defaultValue));
    }

    @Override
    public ResourceLocation getDefaultKey() {
        return this.defaultKey;
    }
}

