// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a System Integrity Protection (SIP) modification task to configure the
// SIP settings for an x86 Mac instance or Apple silicon Mac instance. For more
// information, see [Configure SIP for Amazon EC2 instances]in the Amazon EC2 User Guide.
//
// When you configure the SIP settings for your instance, you can either enable or
// disable all SIP settings, or you can specify a custom SIP configuration that
// selectively enables or disables specific SIP settings.
//
// If you implement a custom configuration, [connect to the instance and verify the settings] to ensure that your requirements are
// properly implemented and functioning as intended.
//
// SIP configurations might change with macOS updates. We recommend that you
// review custom SIP settings after any macOS version upgrade to ensure continued
// compatibility and proper functionality of your security configurations.
//
// To enable or disable all SIP settings, use the
// MacSystemIntegrityProtectionStatus parameter only. For example, to enable all
// SIP settings, specify the following:
//
//   - MacSystemIntegrityProtectionStatus=enabled
//
// To specify a custom configuration that selectively enables or disables specific
// SIP settings, use the MacSystemIntegrityProtectionStatus parameter to enable or
// disable all SIP settings, and then use the
// MacSystemIntegrityProtectionConfiguration parameter to specify exceptions. In
// this case, the exceptions you specify for
// MacSystemIntegrityProtectionConfiguration override the value you specify for
// MacSystemIntegrityProtectionStatus. For example, to enable all SIP settings,
// except NvramProtections , specify the following:
//
//   - MacSystemIntegrityProtectionStatus=enabled
//
//   - MacSystemIntegrityProtectionConfigurationRequest "NvramProtections=disabled"
//
// [Configure SIP for Amazon EC2 instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mac-sip-settings.html#mac-sip-configure
// [connect to the instance and verify the settings]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mac-sip-settings.html#mac-sip-check-settings
func (c *Client) CreateMacSystemIntegrityProtectionModificationTask(ctx context.Context, params *CreateMacSystemIntegrityProtectionModificationTaskInput, optFns ...func(*Options)) (*CreateMacSystemIntegrityProtectionModificationTaskOutput, error) {
	if params == nil {
		params = &CreateMacSystemIntegrityProtectionModificationTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMacSystemIntegrityProtectionModificationTask", params, optFns, c.addOperationCreateMacSystemIntegrityProtectionModificationTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMacSystemIntegrityProtectionModificationTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMacSystemIntegrityProtectionModificationTaskInput struct {

	// The ID of the Amazon EC2 Mac instance.
	//
	// This member is required.
	InstanceId *string

	// Specifies the overall SIP status for the instance. To enable all SIP settings,
	// specify enabled . To disable all SIP settings, specify disabled .
	//
	// This member is required.
	MacSystemIntegrityProtectionStatus types.MacSystemIntegrityProtectionSettingStatus

	// Unique, case-sensitive identifier that you provide to ensure the idempotency of
	// the request. For more information, see [Ensuring Idempotency].
	//
	// [Ensuring Idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	//  [Apple silicon Mac instances only] Specifies the following credentials:
	//
	//   - Internal disk administrative user
	//
	//   - Username - Only the default administrative user ( aws-managed-user ) is
	//   supported and it is used by default. You can't specify a different
	//   administrative user.
	//
	//   - Password - If you did not change the default password for aws-managed-user ,
	//   specify the default password, which is blank. Otherwise, specify your password.
	//
	//   - Amazon EBS root volume administrative user
	//
	//   - Username - If you did not change the default administrative user, specify
	//   ec2-user . Otherwise, specify the username for your administrative user.
	//
	//   - Password - Specify the password for the administrative user.
	//
	// The credentials must be specified in the following JSON format:
	//
	//     { "internalDiskPassword":"internal-disk-admin_password",
	//     "rootVolumeUsername":"root-volume-admin_username",
	//     "rootVolumepassword":"root-volume-admin_password" }
	MacCredentials *string

	// Specifies the overrides to selectively enable or disable individual SIP
	// settings. The individual settings you specify here override the overall SIP
	// status you specify for MacSystemIntegrityProtectionStatus.
	MacSystemIntegrityProtectionConfiguration *types.MacSystemIntegrityProtectionConfigurationRequest

	// Specifies tags to apply to the SIP modification task.
	TagSpecifications []types.TagSpecification

	noSmithyDocumentSerde
}

type CreateMacSystemIntegrityProtectionModificationTaskOutput struct {

	// Information about the SIP modification task.
	MacModificationTask *types.MacModificationTask

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMacSystemIntegrityProtectionModificationTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpCreateMacSystemIntegrityProtectionModificationTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCreateMacSystemIntegrityProtectionModificationTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMacSystemIntegrityProtectionModificationTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateMacSystemIntegrityProtectionModificationTaskMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMacSystemIntegrityProtectionModificationTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMacSystemIntegrityProtectionModificationTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateMacSystemIntegrityProtectionModificationTask struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateMacSystemIntegrityProtectionModificationTask) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateMacSystemIntegrityProtectionModificationTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateMacSystemIntegrityProtectionModificationTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateMacSystemIntegrityProtectionModificationTaskInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateMacSystemIntegrityProtectionModificationTaskMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateMacSystemIntegrityProtectionModificationTask{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateMacSystemIntegrityProtectionModificationTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMacSystemIntegrityProtectionModificationTask",
	}
}
