// Code generated by smithy-go-codegen DO NOT EDIT.

package apigateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apigateway/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Creates a domain name access association resource between an access
//
// association source and a private custom domain name.
func (c *Client) CreateDomainNameAccessAssociation(ctx context.Context, params *CreateDomainNameAccessAssociationInput, optFns ...func(*Options)) (*CreateDomainNameAccessAssociationOutput, error) {
	if params == nil {
		params = &CreateDomainNameAccessAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDomainNameAccessAssociation", params, optFns, c.addOperationCreateDomainNameAccessAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDomainNameAccessAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDomainNameAccessAssociationInput struct {

	//  The identifier of the domain name access association source. For a VPCE, the
	// value is the VPC endpoint ID.
	//
	// This member is required.
	AccessAssociationSource *string

	//  The type of the domain name access association source.
	//
	// This member is required.
	AccessAssociationSourceType types.AccessAssociationSourceType

	//  The ARN of the domain name.
	//
	// This member is required.
	DomainNameArn *string

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The
	// tag key can be up to 128 characters and must not start with aws: . The tag value
	// can be up to 256 characters.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Represents a domain name access association between an access association
// source and a private custom domain name. With a domain name access association,
// an access association source can invoke a private custom domain name while
// isolated from the public internet.
type CreateDomainNameAccessAssociationOutput struct {

	//  The ARN of the domain name access association source. For a VPCE, the ARN must
	// be a VPC endpoint.
	AccessAssociationSource *string

	//  The type of the domain name access association source.
	AccessAssociationSourceType types.AccessAssociationSourceType

	// The ARN of the domain name access association resource.
	DomainNameAccessAssociationArn *string

	// The ARN of the domain name.
	DomainNameArn *string

	//  The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDomainNameAccessAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDomainNameAccessAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDomainNameAccessAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDomainNameAccessAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDomainNameAccessAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDomainNameAccessAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addAcceptHeader(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDomainNameAccessAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDomainNameAccessAssociation",
	}
}
