/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class Dot11ChannelUsageMode
extends NamedNumber<Byte, Dot11ChannelUsageMode> {
    private static final long serialVersionUID = -8113989723106251697L;
    public static final Dot11ChannelUsageMode NONINFRASTRUCTURE_DOT_11 = new Dot11ChannelUsageMode((byte)0, "Noninfrastructure IEEE 802.11 network");
    public static final Dot11ChannelUsageMode OFF_CHANNEL_TDLS_DIRECT_LINK = new Dot11ChannelUsageMode((byte)1, "Off-channel TDLS direct link");
    private static final Map<Byte, Dot11ChannelUsageMode> registry = new HashMap<Byte, Dot11ChannelUsageMode>();

    public Dot11ChannelUsageMode(Byte value, String name) {
        super(value, name);
    }

    public static Dot11ChannelUsageMode getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new Dot11ChannelUsageMode(value, "unknown");
    }

    public static Dot11ChannelUsageMode register(Dot11ChannelUsageMode number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(Dot11ChannelUsageMode o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        registry.put((Byte)NONINFRASTRUCTURE_DOT_11.value(), NONINFRASTRUCTURE_DOT_11);
        registry.put((Byte)OFF_CHANNEL_TDLS_DIRECT_LINK.value(), OFF_CHANNEL_TDLS_DIRECT_LINK);
    }
}

