/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.tasks.DownloadTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;

public class SubtitleDownloadTask
extends DownloadTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtitleDownloadTask.class);
    private final MediaEntity mediaEntity;
    private final Path destinationFile;
    private final String language;

    public SubtitleDownloadTask(String url, Path destinationFile, MediaEntity mediaEntity, String language) {
        super(TmmResourceBundle.getString("subtitle.downloading"), url);
        this.mediaEntity = mediaEntity;
        this.destinationFile = destinationFile;
        this.language = language;
    }

    @Override
    protected void doInBackground() {
        if (!this.isFeatureEnabled()) {
            return;
        }
        super.doInBackground();
    }

    @Override
    protected Path getDestinationWoExtension() {
        return this.destinationFile;
    }

    @Override
    protected MediaEntity getMediaEntityToAdd() {
        return this.mediaEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void moveDownloadedFile(String fileExtension) throws IOException {
        MediaFile tempMediaFile;
        Path destination = this.getDestinationWoExtension();
        if (!fileExtension.isEmpty()) {
            destination = destination.getParent().resolve(destination.getFileName() + "." + fileExtension);
        }
        if ((tempMediaFile = new MediaFile(this.tempFile)).getType() == MediaFileType.SUBTITLE || !fileExtension.equalsIgnoreCase("zip") && Settings.getInstance().getSubtitleFileType().contains("." + fileExtension)) {
            Utils.deleteFileSafely(destination);
            boolean ok = Utils.moveFileSafe(this.tempFile, destination);
            if (ok) {
                Utils.deleteFileSafely(this.tempFile);
                if (this.mediaEntity != null) {
                    MediaFile mf = new MediaFile(destination);
                    mf.gatherMediaInformation();
                    mf.detectStackingInformation();
                    if (mf.getSubtitles().isEmpty()) {
                        LOGGER.warn("Download to '{}' was ok, but mediainfo did not detect any subtitle info", (Object)this.tempFile);
                        this.setState(TmmTaskHandle.TaskState.FAILED);
                    } else {
                        MediaFileSubtitle subtitle = mf.getSubtitles().get(0);
                        if (StringUtils.isBlank((CharSequence)subtitle.getLanguage())) {
                            subtitle.setLanguage(this.language);
                        }
                        this.mediaEntity.removeFromMediaFiles(mf);
                        this.mediaEntity.addToMediaFiles(mf);
                        this.mediaEntity.saveToDb();
                    }
                }
            } else {
                LOGGER.warn("Download to '{}' was ok, but couldn't move to '{}'", (Object)this.tempFile, (Object)destination);
                this.setState(TmmTaskHandle.TaskState.FAILED);
            }
        } else {
            MediaFile mf = null;
            try (InputStream is = Files.newInputStream(this.tempFile, new OpenOption[0]);
                 ZipInputStream zis = new ZipInputStream(is);){
                ZipEntry ze = zis.getNextEntry();
                SubtitleEntry firstSubtitle = null;
                SubtitleEntry firstTxt = null;
                while (ze != null) {
                    String extension = FilenameUtils.getExtension((String)ze.getName()).toLowerCase(Locale.ROOT);
                    if (Settings.getInstance().getSubtitleFileType().contains("." + extension) || "idx".equals(extension)) {
                        firstSubtitle = new SubtitleEntry(extension, zis.readAllBytes());
                    }
                    if (firstTxt == null && "txt".equals(extension)) {
                        firstTxt = new SubtitleEntry(extension, zis.readAllBytes());
                    }
                    ze = zis.getNextEntry();
                }
                if (firstSubtitle != null) {
                    mf = this.copySubtitleFile(firstSubtitle);
                } else if (firstTxt != null) {
                    mf = this.copySubtitleFile(firstTxt);
                }
                zis.closeEntry();
            }
            catch (Exception e) {
                LOGGER.debug("could not extract subtitle: {}", (Object)e.getMessage());
            }
            finally {
                Utils.deleteFileSafely(this.destinationFile);
            }
            if (mf != null && mf.getType() == MediaFileType.SUBTITLE) {
                if (this.mediaEntity != null) {
                    mf.gatherMediaInformation();
                    mf.detectStackingInformation();
                    if (mf.getSubtitles().isEmpty()) {
                        LOGGER.warn("Download to '{}' was ok, but mediainfo did not detect any subtitle info", (Object)this.tempFile);
                        this.setState(TmmTaskHandle.TaskState.FAILED);
                    } else {
                        MediaFileSubtitle subtitle = mf.getSubtitles().get(0);
                        if (StringUtils.isBlank((CharSequence)subtitle.getLanguage())) {
                            subtitle.setLanguage(this.language);
                        }
                        this.mediaEntity.removeFromMediaFiles(mf);
                        this.mediaEntity.addToMediaFiles(mf);
                        this.mediaEntity.saveToDb();
                    }
                }
            } else {
                this.setState(TmmTaskHandle.TaskState.FAILED);
            }
        }
    }

    private MediaFile copySubtitleFile(SubtitleEntry entry) throws IOException {
        String extension = "txt".equals(entry.extension) ? "srt" : entry.extension;
        Path destination = this.getDestinationWoExtension();
        destination = destination.getParent().resolve(destination.getFileName() + "." + extension);
        try (FileOutputStream os = new FileOutputStream(destination.toFile());){
            IOUtils.write((byte[])entry.buffer, (OutputStream)os);
            MediaFile mediaFile = new MediaFile(destination);
            return mediaFile;
        }
    }

    private static class SubtitleEntry {
        private final String extension;
        private final byte[] buffer;

        public SubtitleEntry(String extenstion, byte[] buffer) {
            this.extension = extenstion;
            this.buffer = buffer;
        }
    }
}

