/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.nio.file.Path;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowSeasonNfoParser;

public enum TvShowConnectors {
    KODI("Kodi"),
    XBMC("Kodi / XBMC < v16"),
    EMBY("Emby"),
    JELLYFIN("Jellyfin"),
    PLEX("Plex"),
    MEDIAPORTAL("MediaPortal");

    private final String title;

    private TvShowConnectors(String title) {
        this.title = title;
    }

    public String toString() {
        return this.title;
    }

    public static boolean isValidTvShowNFO(Path nfo) {
        try {
            TvShowNfoParser tvShowNfoParser = TvShowNfoParser.parseNfo(nfo);
            return tvShowNfoParser.isValidNfo();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidTvShowSeasonNFO(Path nfo) {
        try {
            TvShowSeasonNfoParser tvShowNfoParser = TvShowSeasonNfoParser.parseNfo(nfo);
            return tvShowNfoParser.isValidNfo();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidTvShowEpisodeNFO(Path nfo) {
        try {
            TvShowEpisodeNfoParser tvShowNfoParser = TvShowEpisodeNfoParser.parseNfo(nfo);
            return tvShowNfoParser.isValidNfo();
        }
        catch (Exception e) {
            return false;
        }
    }
}

