/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.omdb;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.omdb.OmdbMetadataProvider;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.TvUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public class OmdbTvShowMetadataProvider
extends OmdbMetadataProvider
implements ITvShowMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmdbTvShowMetadataProvider.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(60L, 10L);

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata() - TvShow: '{}'", (Object)options);
        String imdbId = this.getImdbId(options);
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("no imdb id found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        Document doc = null;
        try {
            doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&i=" + imdbId + "&type=series&plot=full&tomatoes=true&r=xml");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc == null || doc.childrenSize() == 0) {
            LOGGER.debug("no result found");
            throw new NothingFoundException();
        }
        MediaMetadata metadata = this.parseDetail(doc, "movie");
        if (metadata == null) {
            LOGGER.debug("no result found");
            throw new NothingFoundException();
        }
        metadata.setScrapeOptions(options);
        return metadata;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        MediaMetadata metadata2;
        LOGGER.debug("getMetadata() - episode: '{}'", (Object)options);
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        List<MediaMetadata> episodeList = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
        if (episodeList.isEmpty()) {
            LOGGER.debug("EpisodeList is empty, cannot fetch episode information");
            throw new NothingFoundException();
        }
        String imdbId = "";
        for (MediaMetadata metadata2 : episodeList) {
            MediaEpisodeNumber episodeNumber = metadata2.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED);
            if (episodeNumber == null || seasonNr != episodeNumber.season() || episodeNr != episodeNumber.episode()) continue;
            imdbId = metadata2.getId("imdb").toString();
            break;
        }
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("no imdb id found for season '{}' episode '{}'", (Object)seasonNr, (Object)episodeNr);
            throw new MissingIdException(new String[0]);
        }
        Document doc = null;
        try {
            doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&i=" + imdbId + "&type=episode&plot=full&tomatoes=true&r=xml");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc == null || doc.childrenSize() == 0) {
            LOGGER.debug("no result found");
            throw new NothingFoundException();
        }
        metadata2 = this.parseDetail(doc, "movie");
        if (metadata2 == null) {
            LOGGER.debug("no result found");
            throw new NothingFoundException();
        }
        metadata2.setScrapeOptions(options);
        return metadata2;
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options.getSearchQuery());
        TreeSet<MediaSearchResult> mediaResult = new TreeSet<MediaSearchResult>();
        if (MediaIdUtil.isValidImdbId(options.getImdbId())) {
            try {
                MediaMetadata md = this.getMetadata(options);
                MediaSearchResult result = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
                result.setMetadata(md);
                result.setTitle(md.getTitle());
                result.setIMDBId(options.getImdbId());
                result.setYear(md.getYear());
                for (MediaArtwork artwork : md.getMediaArt(MediaArtwork.MediaArtworkType.POSTER)) {
                    result.setPosterUrl(artwork.getPreviewUrl());
                }
                result.setScore(1.0f);
                mediaResult.add(result);
                return mediaResult;
            }
            catch (Exception e) {
                LOGGER.debug("could not fetch data with imdb id - '{}'", (Object)e.getMessage());
            }
        }
        Document doc = null;
        try {
            doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&s=" + options.getSearchQuery() + "&type=series&page=1&r=xml");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc == null || doc.childrenSize() == 0) {
            LOGGER.debug("no result found");
            throw new NothingFoundException();
        }
        List<MediaSearchResult> searchResults = this.parseSearchResults(doc, MediaType.TV_SHOW);
        if (searchResults.isEmpty()) {
            try {
                MediaMetadata md;
                doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&t=" + options.getSearchQuery() + "&type=series&r=xml");
                if (doc != null && doc.childrenSize() != 0 && (md = this.parseDetail(doc, "movie")) != null) {
                    md.setScrapeOptions(options);
                    MediaSearchResult searchResult = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
                    searchResult.mergeFrom(md);
                    searchResults = Collections.singletonList(searchResult);
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.debug("error searching: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        for (MediaSearchResult searchResult : searchResults) {
            searchResult.calculateScore(options);
            mediaResult.add(searchResult);
        }
        return mediaResult;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList(): {}", (Object)options.getSearchQuery());
        String imdbId = this.getImdbId(options);
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            throw new MissingIdException(new String[]{"imdbId"});
        }
        List<MediaMetadata> episodeList = EPISODE_LIST_CACHE_MAP.get(imdbId + "_" + options.getLanguage().getLanguage());
        if (ListUtils.isNotEmpty(episodeList)) {
            return episodeList;
        }
        episodeList = new ArrayList<MediaMetadata>();
        if (StringUtils.isBlank((CharSequence)this.getApiKey())) {
            LOGGER.debug("no API Key found");
            throw new ScrapeException(new HttpException(401, "Unauthorized"));
        }
        Document doc = null;
        try {
            doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&i=" + imdbId + "&type=series&r=xml&Season=1");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc == null || doc.childrenSize() == 0) {
            LOGGER.debug("no result found");
            throw new NothingFoundException();
        }
        Element root = doc.getElementsByTag("root").first();
        if (root == null) {
            throw new NothingFoundException();
        }
        int seasons = MetadataUtil.parseInt(root.attr("totalSeasons"), 0);
        if (seasons <= 0) {
            throw new NothingFoundException();
        }
        episodeList.addAll(this.parseEpisodes(doc, options));
        for (int i = 2; i <= seasons; ++i) {
            try {
                doc = UrlUtil.parseDocumentFromUrl("https://www.omdbapi.com/?apikey=" + this.getApiKey() + "&i=" + imdbId + "&type=series&r=xml&Season=" + i);
                episodeList.addAll(this.parseEpisodes(doc, options));
                continue;
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        if (!episodeList.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(imdbId + "_" + options.getLanguage().getLanguage(), episodeList);
        }
        return episodeList;
    }

    private List<MediaMetadata> parseEpisodes(Document document, MediaSearchAndScrapeOptions options) {
        Element root = document.getElementsByTag("root").first();
        if (root == null) {
            return Collections.emptyList();
        }
        int season = MetadataUtil.parseInt(root.attr("season"), -1);
        if (season < 0) {
            return Collections.emptyList();
        }
        Elements results = document.getElementsByTag("result");
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        for (Element result : results) {
            MediaMetadata md = new MediaMetadata(this.getId());
            md.setScrapeOptions(options);
            if (MediaIdUtil.isValidImdbId(result.attr("imdbID"))) {
                md.setId("imdb", result.attr("imdbID"));
            }
            md.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, season, TvUtils.getEpisodeNumber(result.attr("episode"), -1));
            md.setTitle(result.attr("Title"));
            try {
                md.setReleaseDate(DateUtils.parseDate(result.attr("released")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                MediaRating rating = new MediaRating("imdb");
                rating.setRating(Float.parseFloat(result.attr("imdbRating")));
                rating.setMaxValue(10);
                md.addRating(rating);
            }
            catch (NumberFormatException e) {
                this.getLogger().trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
            episodes.add(md);
        }
        return episodes;
    }
}

