/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.loading.FMLConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModWorkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long PARK_TIME = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final SyncExecutor syncExecutor = new SyncExecutor();

    public static DrivenExecutor syncExecutor() {
        return syncExecutor;
    }

    public static DrivenExecutor wrappedExecutor(Executor executor) {
        return new WrappingExecutor(executor);
    }

    public static Executor parallelExecutor() {
        return LazyInit.PARALLEL_EXECUTOR;
    }

    private static ForkJoinWorkerThread newForkJoinWorkerThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        thread.setName("modloading-worker-" + thread.getPoolIndex());
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        return thread;
    }

    private record SyncExecutor(ConcurrentLinkedDeque<Runnable> tasks) implements DrivenExecutor
    {
        public SyncExecutor() {
            this(new ConcurrentLinkedDeque<Runnable>());
        }

        @Override
        public boolean driveOne() {
            Runnable task = this.tasks.pollFirst();
            if (task != null) {
                task.run();
            }
            return task != null;
        }

        @Override
        public boolean selfDriven() {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            this.tasks.addLast(command);
        }
    }

    private record WrappingExecutor(Executor wrapped) implements DrivenExecutor
    {
        @Override
        public boolean selfDriven() {
            return true;
        }

        @Override
        public boolean driveOne() {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            this.wrapped.execute(command);
        }
    }

    private static final class LazyInit {
        private static final ForkJoinPool PARALLEL_EXECUTOR;

        private LazyInit() {
        }

        static {
            int loadingThreadCount = FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.MAX_THREADS);
            LOGGER.debug(Logging.LOADING, "Using {} threads for parallel mod-loading", (Object)loadingThreadCount);
            PARALLEL_EXECUTOR = new ForkJoinPool(loadingThreadCount, ModWorkManager::newForkJoinWorkerThread, null, false);
        }
    }

    public static interface DrivenExecutor
    extends Executor {
        public boolean selfDriven();

        public boolean driveOne();

        default public void drive(Runnable ticker) {
            if (!this.selfDriven()) {
                ticker.run();
                while (this.driveOne()) {
                }
            } else {
                LockSupport.parkNanos(PARK_TIME);
            }
        }
    }
}

