/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class RenderTooltipEvent
extends MutableEvent
implements InheritableEvent {
    public static final EventBus<RenderTooltipEvent> BUS = EventBus.create(RenderTooltipEvent.class);
    @NotNull
    protected final ItemStack itemStack;
    protected final GuiGraphics graphics;
    protected int x;
    protected int y;
    protected Font font;
    protected final List<ClientTooltipComponent> components;

    @ApiStatus.Internal
    protected RenderTooltipEvent(@NotNull ItemStack itemStack, GuiGraphics graphics, int x, int y, @NotNull Font font, @NotNull List<ClientTooltipComponent> components) {
        this.itemStack = itemStack;
        this.graphics = graphics;
        this.components = Collections.unmodifiableList(components);
        this.x = x;
        this.y = y;
        this.font = font;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public GuiGraphics getGraphics() {
        return this.graphics;
    }

    @NotNull
    public List<ClientTooltipComponent> getComponents() {
        return this.components;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @NotNull
    public Font getFont() {
        return this.font;
    }

    public static final class Background
    extends RenderTooltipEvent {
        public static final EventBus<Background> BUS = EventBus.create(Background.class);
        private final ResourceLocation originalBackground;
        private ResourceLocation background;

        @ApiStatus.Internal
        public Background(@NotNull ItemStack stack, GuiGraphics graphics, int x, int y, @NotNull Font fr, @NotNull List<ClientTooltipComponent> components, @Nullable ResourceLocation background) {
            super(stack, graphics, x, y, fr, components);
            this.originalBackground = background;
            this.background = background;
        }

        public void setBackground(ResourceLocation background) {
            this.background = background;
        }

        public ResourceLocation getBackground() {
            return this.background;
        }

        public ResourceLocation getOriginalBackground() {
            return this.originalBackground;
        }
    }

    public static final class Pre
    extends RenderTooltipEvent
    implements Cancellable {
        public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        private final int screenWidth;
        private final int screenHeight;
        private final ClientTooltipPositioner positioner;

        @ApiStatus.Internal
        public Pre(@NotNull ItemStack stack, GuiGraphics graphics, int x, int y, int screenWidth, int screenHeight, @NotNull Font font, @NotNull List<ClientTooltipComponent> components, @NotNull ClientTooltipPositioner positioner) {
            super(stack, graphics, x, y, font, components);
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.positioner = positioner;
        }

        public int getScreenWidth() {
            return this.screenWidth;
        }

        public int getScreenHeight() {
            return this.screenHeight;
        }

        public ClientTooltipPositioner getTooltipPositioner() {
            return this.positioner;
        }

        public void setFont(@NotNull Font fr) {
            this.font = fr;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }
    }

    public static final class GatherComponents
    extends MutableEvent
    implements Cancellable {
        public static final CancellableEventBus<GatherComponents> BUS = CancellableEventBus.create(GatherComponents.class);
        private final ItemStack itemStack;
        private final int screenWidth;
        private final int screenHeight;
        private final List<Either<FormattedText, TooltipComponent>> tooltipElements;
        private int maxWidth;

        @ApiStatus.Internal
        public GatherComponents(ItemStack itemStack, int screenWidth, int screenHeight, List<Either<FormattedText, TooltipComponent>> tooltipElements, int maxWidth) {
            this.itemStack = itemStack;
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.tooltipElements = tooltipElements;
            this.maxWidth = maxWidth;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public int getScreenWidth() {
            return this.screenWidth;
        }

        public int getScreenHeight() {
            return this.screenHeight;
        }

        public List<Either<FormattedText, TooltipComponent>> getTooltipElements() {
            return this.tooltipElements;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }
    }
}

