/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import net.minecraft.core.RegistryAccess;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;

public final class TagsUpdatedEvent
extends MutableEvent {
    public static final EventBus<TagsUpdatedEvent> BUS = EventBus.create(TagsUpdatedEvent.class);
    private final RegistryAccess registryAccess;
    private final UpdateCause updateCause;
    private final boolean integratedServer;

    public TagsUpdatedEvent(RegistryAccess registryAccess, boolean fromClientPacket, boolean isIntegratedServerConnection) {
        this.registryAccess = registryAccess;
        this.updateCause = fromClientPacket ? UpdateCause.CLIENT_PACKET_RECEIVED : UpdateCause.SERVER_DATA_LOAD;
        this.integratedServer = isIntegratedServerConnection;
    }

    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    public UpdateCause getUpdateCause() {
        return this.updateCause;
    }

    public boolean shouldUpdateStaticData() {
        return this.updateCause == UpdateCause.SERVER_DATA_LOAD || !this.integratedServer;
    }

    public static enum UpdateCause {
        SERVER_DATA_LOAD,
        CLIENT_PACKET_RECEIVED;

    }
}

