/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.Nullable;

public abstract sealed class PistonEvent
extends BlockEvent {
    public static final EventBus<PistonEvent> BUS = EventBus.create(PistonEvent.class);
    private final Direction direction;
    private final PistonMoveType moveType;

    public PistonEvent(Level world, BlockPos pos, Direction direction, PistonMoveType moveType) {
        super((LevelAccessor)world, pos, world.getBlockState(pos));
        this.direction = direction;
        this.moveType = moveType;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getFaceOffsetPos() {
        return this.getPos().relative(this.direction);
    }

    public PistonMoveType getPistonMoveType() {
        return this.moveType;
    }

    @Nullable
    public PistonStructureResolver getStructureHelper() {
        if (this.getLevel() instanceof Level) {
            return new PistonStructureResolver((Level)this.getLevel(), this.getPos(), this.getDirection(), this.getPistonMoveType().isExtend);
        }
        return null;
    }

    public static enum PistonMoveType {
        EXTEND(true),
        RETRACT(false);

        public final boolean isExtend;

        private PistonMoveType(boolean isExtend) {
            this.isExtend = isExtend;
        }
    }

    public static final class Pre
    extends PistonEvent
    implements Cancellable {
        public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

        public Pre(Level world, BlockPos pos, Direction direction, PistonMoveType moveType) {
            super(world, pos, direction, moveType);
        }
    }

    public static final class Post
    extends PistonEvent {
        public static final EventBus<Post> BUS = EventBus.create(Post.class);

        public Post(Level world, BlockPos pos, Direction direction, PistonMoveType moveType) {
            super(world, pos, direction, moveType);
        }
    }
}

