/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ForgeEventFactoryClient;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractClientPlayer
extends Player {
    @Nullable
    private PlayerInfo playerInfo;
    protected Vec3 deltaMovementOnPreviousTick = Vec3.ZERO;
    public float elytraRotX;
    public float elytraRotY;
    public float elytraRotZ;
    public final ClientLevel clientLevel;
    public float walkDistO;
    public float walkDist;

    public AbstractClientPlayer(ClientLevel p_250460_, GameProfile p_249912_) {
        super(p_250460_, p_249912_);
        this.clientLevel = p_250460_;
    }

    @Override
    @Nullable
    public GameType gameMode() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo != null ? playerinfo.getGameMode() : null;
    }

    @Nullable
    protected PlayerInfo getPlayerInfo() {
        if (this.playerInfo == null) {
            this.playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(this.getUUID());
        }
        return this.playerInfo;
    }

    @Override
    public void tick() {
        this.walkDistO = this.walkDist;
        this.deltaMovementOnPreviousTick = this.getDeltaMovement();
        super.tick();
    }

    public Vec3 getDeltaMovementLerped(float p_272943_) {
        return this.deltaMovementOnPreviousTick.lerp(this.getDeltaMovement(), p_272943_);
    }

    public PlayerSkin getSkin() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? DefaultPlayerSkin.get((UUID)this.getUUID()) : playerinfo.getSkin();
    }

    public float getFieldOfViewModifier(boolean p_361176_, float p_362521_) {
        float f1;
        float f = 1.0f;
        if (this.getAbilities().flying) {
            f *= 1.1f;
        }
        if ((f1 = this.getAbilities().getWalkingSpeed()) != 0.0f) {
            float f2 = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) / f1;
            f *= (f2 + 1.0f) / 2.0f;
        }
        if (this.isUsingItem()) {
            if (this.getUseItem().is(Items.BOW)) {
                float f3 = Math.min((float)this.getTicksUsingItem() / 20.0f, 1.0f);
                f *= 1.0f - Mth.square(f3) * 0.15f;
            } else if (p_361176_ && this.isScoping()) {
                return 0.1f;
            }
        }
        return ForgeEventFactoryClient.fireFovModifierEvent((Player)this, (float)f, (float)p_362521_).getNewFovModifier();
    }
}

