/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class ThrownEnderpearl
extends ThrowableItemProjectile {
    private long ticketTimer = 0L;

    public ThrownEnderpearl(EntityType<? extends ThrownEnderpearl> p_37491_, Level p_37492_) {
        super((EntityType<? extends ThrowableItemProjectile>)p_37491_, p_37492_);
    }

    public ThrownEnderpearl(Level p_37499_, LivingEntity p_37500_, ItemStack p_365479_) {
        super(EntityType.ENDER_PEARL, p_37500_, p_37499_, p_365479_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void setOwner(@Nullable EntityReference<Entity> p_408475_) {
        this.deregisterFromCurrentOwner();
        super.setOwner(p_408475_);
        this.registerToCurrentOwner();
    }

    private void deregisterFromCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.deregisterEnderPearl(this);
        }
    }

    private void registerToCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.registerEnderPearl(this);
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        Entity entity;
        Level level;
        if (this.owner != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            entity = this.owner.getEntity(p_406854_ -> ThrownEnderpearl.findOwnerInAnyDimension(serverlevel, p_406854_), Entity.class);
        } else {
            entity = super.getOwner();
        }
        return entity;
    }

    @Nullable
    private static Entity findOwnerInAnyDimension(ServerLevel p_410395_, UUID p_409462_) {
        Entity entity = p_410395_.getEntity(p_409462_);
        if (entity != null) {
            return entity;
        }
        for (ServerLevel serverlevel : p_410395_.getServer().getAllLevels()) {
            if (serverlevel == p_410395_ || (entity = serverlevel.getEntity(p_409462_)) == null) continue;
            return entity;
        }
        return null;
    }

    @Override
    protected void onHitEntity(EntityHitResult p_37502_) {
        super.onHitEntity(p_37502_);
        p_37502_.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(HitResult p_37504_) {
        super.onHit(p_37504_);
        for (int i = 0; i < 32; ++i) {
            this.level().addParticle(ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (!this.isRemoved()) {
                Entity entity = this.getOwner();
                if (entity != null && ThrownEnderpearl.isAllowedToTeleportOwner(entity, serverlevel)) {
                    Vec3 vec3 = this.oldPosition();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)entity;
                        if (serverplayer.connection.isAcceptingMessages()) {
                            ServerPlayer serverplayer1;
                            Endermite endermite;
                            EntityTeleportEvent.EnderPearl event = ForgeEventFactory.onEnderPearlLand((ServerPlayer)serverplayer, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ThrownEnderpearl)this, (float)5.0f, (HitResult)p_37504_);
                            if (event == null) {
                                this.discard();
                                return;
                            }
                            vec3 = event.getTarget();
                            if (this.random.nextFloat() < 0.05f && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (endermite = EntityType.ENDERMITE.create(serverlevel, EntitySpawnReason.TRIGGERED)) != null) {
                                endermite.snapTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                                serverlevel.addFreshEntity(endermite);
                            }
                            if (this.isOnPortalCooldown()) {
                                entity.setPortalCooldown();
                            }
                            if ((serverplayer1 = serverplayer.teleport(new TeleportTransition(serverlevel, vec3, Vec3.ZERO, 0.0f, 0.0f, Relative.union(Relative.ROTATION, Relative.DELTA), TeleportTransition.DO_NOTHING))) != null) {
                                serverplayer1.resetFallDistance();
                                serverplayer1.resetCurrentImpulseContext();
                                serverplayer1.hurtServer(serverplayer.level(), this.damageSources().enderPearl(), event.getAttackDamage());
                            }
                            this.playSound(serverlevel, vec3);
                        }
                    } else {
                        Entity entity1 = entity.teleport(new TeleportTransition(serverlevel, vec3, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING));
                        if (entity1 != null) {
                            entity1.resetFallDistance();
                        }
                        this.playSound(serverlevel, vec3);
                    }
                    this.discard();
                } else {
                    this.discard();
                }
            }
        }
    }

    private static boolean isAllowedToTeleportOwner(Entity p_343823_, Level p_342445_) {
        if (p_343823_.level().dimension() == p_342445_.dimension()) {
            boolean bl;
            if (!(p_343823_ instanceof LivingEntity)) {
                bl = p_343823_.isAlive();
            } else {
                LivingEntity livingentity = (LivingEntity)p_343823_;
                bl = livingentity.isAlive() && !livingentity.isSleeping();
            }
            return bl;
        }
        return p_343823_.canUsePortal(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick() {
        i = SectionPos.blockToSectionCoord(this.position().x());
        j = SectionPos.blockToSectionCoord(this.position().z());
        entity = this.getOwner();
        if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
        serverplayer = (ServerPlayer)entity;
        if (!entity.isAlive() && serverplayer.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else lbl-1000:
        // 2 sources

        {
            super.tick();
        }
        if (this.isAlive()) {
            blockpos = BlockPos.containing(this.position());
            if ((--this.ticketTimer <= 0L || i != SectionPos.blockToSectionCoord(blockpos.getX()) || j != SectionPos.blockToSectionCoord(blockpos.getZ())) && entity instanceof ServerPlayer) {
                serverplayer1 = (ServerPlayer)entity;
                this.ticketTimer = serverplayer1.registerAndUpdateEnderPearlTicket(this);
            }
        }
    }

    private void playSound(Level p_344184_, Vec3 p_345358_) {
        p_344184_.playSound(null, p_345358_.x, p_345358_.y, p_345358_.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition p_361132_) {
        Entity entity = super.teleport(p_361132_);
        if (entity != null) {
            entity.placePortalTicket(BlockPos.containing(entity.position()));
        }
        return entity;
    }

    @Override
    public boolean canTeleport(Level p_366889_, Level p_366581_) {
        boolean bl;
        Entity entity;
        if (p_366889_.dimension() == Level.END && p_366581_.dimension() == Level.OVERWORLD && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            bl = super.canTeleport(p_366889_, p_366581_) && serverplayer.seenCredits;
        } else {
            bl = super.canTeleport(p_366889_, p_366581_);
        }
        return bl;
    }

    @Override
    protected void onInsideBlock(BlockState p_345184_) {
        Entity entity;
        super.onInsideBlock(p_345184_);
        if (p_345184_.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.onInsideBlock(p_345184_);
        }
    }

    @Override
    public void onRemoval(Entity.RemovalReason p_366133_) {
        if (p_366133_ != Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            this.deregisterFromCurrentOwner();
        }
        super.onRemoval(p_366133_);
    }

    @Override
    public void onAboveBubbleColumn(boolean p_394879_, BlockPos p_391809_) {
        Entity.handleOnAboveBubbleColumn(this, p_394879_, p_391809_);
    }

    @Override
    public void onInsideBubbleColumn(boolean p_396065_) {
        Entity.handleOnInsideBubbleColumn(this, p_396065_);
    }
}

