/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.roimfs;

class GlobUtil {
    GlobUtil() {
    }

    public static final String convertGlobToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

