/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.roimfs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import net.minecraftforge.roimfs.RoimPath;

class RoimFileAttributeView
implements BasicFileAttributeView {
    private static final Attributes DIRECTORY = new Attributes(0L, false);
    private final RoimPath path;

    RoimFileAttributeView(RoimPath path) {
        this.path = path;
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public BasicFileAttributes readAttributes() throws IOException {
        String real = this.path.toRealPath(new LinkOption[0]).toString();
        if (this.path.fs.isDirectory(real)) {
            return DIRECTORY;
        }
        return new Attributes(this.path.fs.getFile(real).length, true);
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    static class Attributes
    implements BasicFileAttributes {
        private static final FileTime TIME = FileTime.fromMillis(628070400000L);
        private final long size;
        private final boolean isFile;

        Attributes(long size, boolean isFile) {
            this.size = size;
            this.isFile = isFile;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public boolean isRegularFile() {
            return this.isFile;
        }

        @Override
        public boolean isDirectory() {
            return !this.isRegularFile();
        }

        @Override
        public FileTime lastModifiedTime() {
            return TIME;
        }

        @Override
        public FileTime lastAccessTime() {
            return TIME;
        }

        @Override
        public FileTime creationTime() {
            return TIME;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    }
}

