/*
 * Decompiled with CFR 0.152.
 */
package com.nothome.delta.text;

import com.nothome.delta.text.CharBufferSeekableSource;
import com.nothome.delta.text.Checksum;
import com.nothome.delta.text.DiffTextWriter;
import com.nothome.delta.text.GDiffTextWriter;
import com.nothome.delta.text.SeekableSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;

public class Delta {
    static final boolean debug = false;
    public static final int DEFAULT_CHUNK_SIZE = 16;
    private int S;
    private SourceState source;
    private TargetState target;
    private DiffTextWriter output;

    public Delta() {
        this.setChunkSize(16);
    }

    public void setChunkSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size");
        }
        this.S = size;
    }

    public void compute(CharSequence source, CharSequence target, Writer output) throws IOException {
        this.compute(new CharBufferSeekableSource(source), new StringReader(((Object)target).toString()), new GDiffTextWriter(output));
    }

    public String compute(CharSequence source, CharSequence target) throws IOException {
        StringWriter sw = new StringWriter();
        this.compute(source, target, sw);
        return sw.toString();
    }

    public void compute(SeekableSource seekSource, Reader targetIS, DiffTextWriter output) throws IOException {
        this.source = new SourceState(seekSource);
        this.target = new TargetState(targetIS);
        this.output = output;
        while (!this.target.eof()) {
            this.debug("!target.eof()");
            int index = this.target.find(this.source);
            if (index != -1) {
                int offset = index * this.S;
                this.source.seek(offset);
                int match = this.target.longestMatch(this.source);
                if (match >= this.S) {
                    output.addCopy(offset, match);
                    continue;
                }
                this.target.tbuf.position(this.target.tbuf.position() - match);
                this.addData();
                continue;
            }
            this.addData();
        }
        output.close();
    }

    private void addData() throws IOException {
        int i = this.target.read();
        if (i == -1) {
            return;
        }
        this.output.addData((char)i);
    }

    private void debug(String s) {
    }

    static Reader forFile(File name) throws FileNotFoundException {
        FileInputStream f1 = new FileInputStream(name);
        InputStreamReader isr = new InputStreamReader(f1);
        return new BufferedReader(isr);
    }

    static CharSequence toString(Reader r) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder();
        while ((read = r.read()) != -1) {
            sb.append((char)read);
        }
        return sb;
    }

    public static void main(String[] s) throws IOException {
        if (s.length != 2) {
            System.err.println("Usage: java ...Delta file1 file2 [> somefile]");
            return;
        }
        Reader r1 = Delta.forFile(new File(s[0]));
        File f2 = new File(s[1]);
        Reader r2 = Delta.forFile(f2);
        CharSequence sb = Delta.toString(r1);
        Delta d = new Delta();
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        d.compute(new CharBufferSeekableSource(sb), r2, new GDiffTextWriter(osw));
        osw.close();
    }

    class TargetState {
        private Readable c;
        private CharBuffer tbuf = CharBuffer.allocate(this.blocksize());
        private CharBuffer sbuf = CharBuffer.allocate(this.blocksize());
        private long hash;
        private boolean hashReset = true;
        private boolean eof;

        TargetState(Reader targetIS) throws IOException {
            this.c = targetIS;
            this.tbuf.limit(0);
        }

        private int blocksize() {
            return Math.max(8192, Delta.this.S * 4);
        }

        public int find(SourceState source) throws IOException {
            if (this.eof) {
                return -1;
            }
            this.sbuf.clear();
            this.sbuf.limit(0);
            if (this.hashReset) {
                Delta.this.debug("hashReset");
                while (this.tbuf.remaining() < Delta.this.S) {
                    this.tbuf.compact();
                    int read = this.c.read(this.tbuf);
                    this.tbuf.flip();
                    if (read != -1) continue;
                    Delta.this.debug("target ending");
                    return -1;
                }
                this.hash = Checksum.queryChecksum(this.tbuf, Delta.this.S);
                this.hashReset = false;
            }
            return source.checksum.findChecksumIndex(this.hash);
        }

        public boolean eof() {
            return this.eof;
        }

        public int read() throws IOException {
            if (this.tbuf.remaining() <= Delta.this.S) {
                this.readMore();
            }
            if (!this.tbuf.hasRemaining()) {
                this.eof = true;
                return -1;
            }
            char b = this.tbuf.get();
            if (this.tbuf.remaining() >= Delta.this.S) {
                char nchar = this.tbuf.get(this.tbuf.position() + Delta.this.S - 1);
                this.hash = Checksum.incrementChecksum(this.hash, b, nchar, Delta.this.S);
            } else {
                Delta.this.debug("out of char");
            }
            return b;
        }

        public int longestMatch(SourceState source) throws IOException {
            Delta.this.debug("longestMatch");
            int match = 0;
            this.hashReset = true;
            while (true) {
                if (!this.sbuf.hasRemaining()) {
                    this.sbuf.clear();
                    int read = source.source.read(this.sbuf);
                    this.sbuf.flip();
                    if (read == -1) {
                        return match;
                    }
                }
                if (!this.tbuf.hasRemaining()) {
                    this.readMore();
                    if (!this.tbuf.hasRemaining()) {
                        Delta.this.debug("target ending");
                        this.eof = true;
                        return match;
                    }
                }
                if (this.sbuf.get() != this.tbuf.get()) {
                    this.tbuf.position(this.tbuf.position() - 1);
                    return match;
                }
                ++match;
            }
        }

        private void readMore() throws IOException {
            this.tbuf.compact();
            this.c.read(this.tbuf);
            this.tbuf.flip();
        }

        void hash() {
            this.hash = Checksum.queryChecksum(this.tbuf, Delta.this.S);
        }

        public String toString() {
            return "Target[ targetBuff=" + this.dump() + " sourceBuff=" + this.sbuf + " hashf=" + this.hash + " eof=" + this.eof + "]";
        }

        private String dump() {
            return this.dump(this.tbuf);
        }

        private String dump(CharBuffer bb) {
            bb.mark();
            StringBuilder sb = new StringBuilder();
            while (bb.hasRemaining()) {
                sb.append(bb.get());
            }
            bb.reset();
            return sb.toString();
        }
    }

    class SourceState {
        private Checksum checksum;
        private SeekableSource source;

        public SourceState(SeekableSource source) throws IOException {
            this.checksum = new Checksum(source, Delta.this.S);
            this.source = source;
            source.seek(0L);
        }

        public void seek(long index) throws IOException {
            this.source.seek(index);
        }

        public String toString() {
            return "Source checksum=" + this.checksum + " source=" + this.source + "";
        }
    }
}

