/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.overlay;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import net.minecraftforge.client.gui.overlay.ForgeLayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@FieldsAreNonnullByDefault
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class ForgeLayeredDraw
implements ForgeLayer {
    private final Map<ResourceLocation, ForgeLayer> namedLayers = new HashMap<ResourceLocation, ForgeLayer>();
    private final Map<ResourceLocation, Map.Entry<ForgeLayeredDraw, BooleanSupplier>> subLayerStacks = new HashMap<ResourceLocation, Map.Entry<ForgeLayeredDraw, BooleanSupplier>>();
    private final List<ResourceLocation> order = new LinkedList<ResourceLocation>();
    private final List<ForgeLayer> bakedLayers = new ArrayList<ForgeLayer>();
    private final ResourceLocation name;
    public static final ResourceLocation PRE_SLEEP_STACK = ResourceLocation.withDefaultNamespace((String)"pre_sleep_phase");
    public static final ResourceLocation CAMERA_OVERLAY = ResourceLocation.withDefaultNamespace((String)"camera_overlay");
    public static final ResourceLocation CROSSHAIR = ResourceLocation.withDefaultNamespace((String)"crosshair");
    public static final ResourceLocation CHANGE_STRATUM = ResourceLocation.withDefaultNamespace((String)"stratum_change");
    public static final ResourceLocation HOTBAR_AND_DECOS = ResourceLocation.withDefaultNamespace((String)"hotbar");
    public static final ResourceLocation POTION_EFFECTS = ResourceLocation.withDefaultNamespace((String)"potion_effects");
    public static final ResourceLocation BOSS_OVERLAY = ResourceLocation.withDefaultNamespace((String)"boss_overlay");
    public static final ResourceLocation POST_SLEEP_STACK = ResourceLocation.withDefaultNamespace((String)"post_sleep_phase");
    public static final ResourceLocation DEMO_OVERLAY = ResourceLocation.withDefaultNamespace((String)"demo");
    public static final ResourceLocation DEBUG_OVERLAY = ResourceLocation.withDefaultNamespace((String)"debug");
    public static final ResourceLocation SCOREBOARD = ResourceLocation.withDefaultNamespace((String)"scoreboard");
    public static final ResourceLocation HOTBAR_MESSAGE = ResourceLocation.withDefaultNamespace((String)"hotbar_message");
    public static final ResourceLocation TITLE_OVERLAY = ResourceLocation.withDefaultNamespace((String)"title");
    public static final ResourceLocation CHAT_OVERLAY = ResourceLocation.withDefaultNamespace((String)"chat_overlay");
    public static final ResourceLocation TAB_LIST = ResourceLocation.withDefaultNamespace((String)"tab_list");
    public static final ResourceLocation SUBTITLE_OVERLAY = ResourceLocation.withDefaultNamespace((String)"subtitle");
    public static final ResourceLocation VANILLA_ROOT = ResourceLocation.withDefaultNamespace((String)"vanilla_root");
    public static final ResourceLocation SLEEP_OVERLAY = ResourceLocation.withDefaultNamespace((String)"sleep_overlay");
    private static final ForgeLayeredDraw instance = new ForgeLayeredDraw(VANILLA_ROOT);

    public ForgeLayeredDraw(ResourceLocation name) {
        this.name = name;
    }

    public ForgeLayeredDraw add(ResourceLocation name, ForgeLayeredDraw layeredDraw, BooleanSupplier supplier) {
        if (this.isNameAvailable(name)) {
            this.subLayerStacks.put(name, Map.entry(layeredDraw, supplier));
            this.order.add(name);
        } else {
            this.nameTakenWarning(name);
        }
        return this;
    }

    public ForgeLayeredDraw add(ResourceLocation targetStack, ResourceLocation name, ForgeLayer layer) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.add(name, layer), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw add(ResourceLocation name, ForgeLayer layer) {
        if (this.isNameAvailable(name)) {
            this.namedLayers.put(name, layer);
            this.order.add(name);
        } else {
            this.nameTakenWarning(name);
        }
        return this;
    }

    public ForgeLayeredDraw putAbove(ResourceLocation expectedStack, ResourceLocation target, ResourceLocation destination) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> stack.move(target, destination, LayerOffset.ABOVE), () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw putBelow(ResourceLocation expectedStack, ResourceLocation target, ResourceLocation destination) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> stack.move(target, destination, LayerOffset.BELOW), () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw move(ResourceLocation target, ResourceLocation destination, LayerOffset offset) {
        if (!this.order.contains(target)) {
            this.layerNotPresentWarning(target);
            return this;
        }
        int loc = this.order.indexOf(destination);
        if (loc == -1) {
            this.layerNotPresentWarning(destination);
            return this;
        }
        this.order.remove(target);
        this.order.add(loc + (offset == LayerOffset.ABOVE ? 1 : 0), target);
        return this;
    }

    public ForgeLayeredDraw addAbove(ResourceLocation expectedStack, ResourceLocation newLayer, ResourceLocation otherLayer, ForgeLayer layer) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> {
            if (!stack.isNameAvailable(otherLayer)) {
                stack.add(newLayer, layer).move(newLayer, otherLayer, LayerOffset.ABOVE);
            } else {
                this.layerNotPresentWarning(otherLayer);
            }
        }, () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw addAbove(ResourceLocation newLayer, ResourceLocation otherLayer, ForgeLayer layer) {
        return this.addAbove(this.name, newLayer, otherLayer, layer);
    }

    public ForgeLayeredDraw addBelow(ResourceLocation expectedStack, ResourceLocation newLayer, ResourceLocation otherLayer, ForgeLayer layer) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> {
            if (!stack.isNameAvailable(otherLayer)) {
                stack.add(newLayer, layer).move(newLayer, otherLayer, LayerOffset.BELOW);
            } else {
                this.layerNotPresentWarning(otherLayer);
            }
        }, () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw addBelow(ResourceLocation newLayer, ResourceLocation otherLayer, ForgeLayer layer) {
        return this.addBelow(this.name, newLayer, otherLayer, layer);
    }

    public ForgeLayeredDraw addWithCondition(ResourceLocation targetStack, ResourceLocation name, ForgeLayer layer, BooleanSupplier condition) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.addWithCondition(name, layer, condition), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw addWithCondition(ResourceLocation name, ForgeLayer layer, BooleanSupplier condition) {
        this.add(name, layer).addConditionTo(name, condition);
        return this;
    }

    public ForgeLayeredDraw addConditionTo(ResourceLocation targetStack, ResourceLocation targetLayer, BooleanSupplier condition) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.addConditionTo(targetLayer, condition), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw addConditionTo(ResourceLocation targetLayer, BooleanSupplier condition) {
        ForgeLayer result = this.namedLayers.computeIfPresent(targetLayer, (name, layer) -> (guiGraphics, deltaTracker) -> {
            if (condition.getAsBoolean()) {
                layer.render(guiGraphics, deltaTracker);
            }
        });
        if (result == null) {
            this.layerNotPresentWarning(targetLayer);
        }
        return this;
    }

    @ApiStatus.Internal
    public ForgeLayeredDraw resolveLayers() {
        if (!this.order.isEmpty()) {
            ForgeEventFactoryClient.onComputeLayerOrder(this);
        }
        this.resolveNested();
        this.order.clear();
        return this;
    }

    private void resolveNested() {
        for (ResourceLocation layerName : this.order) {
            if (this.subLayerStacks.containsKey(layerName)) {
                Map.Entry<ForgeLayeredDraw, BooleanSupplier> entry = this.subLayerStacks.get(layerName);
                entry.getKey().resolveNested();
                this.bakedLayers.add((gg, tr) -> {
                    if (((BooleanSupplier)entry.getValue()).getAsBoolean()) {
                        ((ForgeLayeredDraw)entry.getKey()).render(gg, tr);
                    }
                });
                continue;
            }
            this.bakedLayers.add(this.namedLayers.get(layerName));
        }
    }

    public Optional<ForgeLayeredDraw> locateStack(ResourceLocation targetStack) {
        if (!this.name.equals((Object)targetStack)) {
            for (Map.Entry<ForgeLayeredDraw, BooleanSupplier> value : this.subLayerStacks.values()) {
                ForgeLayeredDraw searchable;
                Optional<ForgeLayeredDraw> res;
                ForgeLayeredDraw forgeLayeredDraw = value.getKey();
                if (!(forgeLayeredDraw instanceof ForgeLayeredDraw) || !(res = (searchable = forgeLayeredDraw).locateStack(targetStack)).isPresent()) continue;
                return res;
            }
            return Optional.empty();
        }
        return Optional.of(this);
    }

    @Nullable
    public ForgeLayeredDraw getChild(ResourceLocation childName) {
        return this.locateStack(childName).orElse(null);
    }

    @Nullable
    public ForgeLayer getLayer(ResourceLocation layerName) {
        return this.namedLayers.get(layerName);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    private void stackNotPresentWarning(ResourceLocation stackName) {
        LogUtils.getLogger().warn("Target stack {} was not present anywhere. Is your ResourceLocation correct?", (Object)stackName);
    }

    private void layerNotPresentWarning(ResourceLocation layer) {
        LogUtils.getLogger().warn("Expected layer {} was not found in stack {}, no layer modifications have been made.", (Object)layer, (Object)this.name);
    }

    private void nameTakenWarning(ResourceLocation layer) {
        LogUtils.getLogger().warn("Name {} was already present in {} and cannot be re-used.", (Object)layer, (Object)this.name);
    }

    private boolean isNameAvailable(ResourceLocation name) {
        return !this.namedLayers.containsKey(name) && !this.subLayerStacks.containsKey(name);
    }

    @ApiStatus.Internal
    public static void beginRender(GuiGraphics gg, DeltaTracker dt) {
        instance.render(gg, dt);
    }

    @Override
    @ApiStatus.Internal
    public void render(GuiGraphics gg, DeltaTracker dt) {
        for (ForgeLayer bakedLayer : this.bakedLayers) {
            bakedLayer.render(gg, dt);
        }
    }

    @ApiStatus.Internal
    public static void init(Gui gui, Minecraft minecraft) {
        ForgeLayeredDraw preSleepDraw = new ForgeLayeredDraw(PRE_SLEEP_STACK).add(CAMERA_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderCameraOverlays(arg_0, arg_1)).add(CROSSHAIR, (arg_0, arg_1) -> ((Gui)gui).renderCrosshair(arg_0, arg_1)).add(CHANGE_STRATUM, (gg, dt) -> gg.nextStratum()).add(HOTBAR_AND_DECOS, (arg_0, arg_1) -> ((Gui)gui).renderHotbarAndDecorations(arg_0, arg_1)).add(POTION_EFFECTS, (arg_0, arg_1) -> ((Gui)gui).renderEffects(arg_0, arg_1)).add(BOSS_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderBossOverlay(arg_0, arg_1));
        ForgeLayeredDraw postSleepDraw = new ForgeLayeredDraw(POST_SLEEP_STACK).add(DEMO_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderDemoOverlay(arg_0, arg_1)).add(SCOREBOARD, (arg_0, arg_1) -> ((Gui)gui).renderScoreboardSidebar(arg_0, arg_1)).add(HOTBAR_MESSAGE, (arg_0, arg_1) -> ((Gui)gui).renderOverlayMessage(arg_0, arg_1)).add(TITLE_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderTitle(arg_0, arg_1)).add(CHAT_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderChat(arg_0, arg_1)).add(TAB_LIST, (arg_0, arg_1) -> ((Gui)gui).renderTabList(arg_0, arg_1)).add(SUBTITLE_OVERLAY, (gfx, delta) -> gui.renderSubtitleOverlay(gfx, minecraft.screen != null && minecraft.screen.isInGameUi()));
        instance.add(PRE_SLEEP_STACK, preSleepDraw, () -> !minecraft.options.hideGui).add(SLEEP_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderSleepOverlay(arg_0, arg_1)).add(POST_SLEEP_STACK, postSleepDraw, () -> !minecraft.options.hideGui).add(SUBTITLE_OVERLAY, (gfx, delta) -> {
            if (minecraft.options.hideGui && minecraft.screen != null && minecraft.screen.isInGameUi()) {
                gui.renderSubtitleOverlay(gfx, true);
            }
        });
        instance.resolveLayers();
    }

    public static enum LayerOffset {
        ABOVE,
        BELOW;

    }
}

