/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;

public final class CapabilityManager {
    @Deprecated(forRemoval=true, since="1.21")
    public static final CapabilityManager INSTANCE = new CapabilityManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AUTO_REGISTER = Type.getType(AutoRegisterCapability.class);
    private static final Map<Key, Capability<?>> providers = new HashMap();

    public static <T> Capability<T> get(CapabilityToken<T> type) {
        return CapabilityManager.get(type.getType(), null, false);
    }

    public static <T> Capability<T> get(CapabilityToken<T> type, String modid, String name) {
        return CapabilityManager.get(type, ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static <T> Capability<T> get(CapabilityToken<T> type, ResourceLocation name) {
        return CapabilityManager.get(type.getType(), name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Capability<T> get(String type, ResourceLocation name, boolean registering) {
        Capability cap;
        Object object = providers;
        synchronized (object) {
            Capability parent = providers.computeIfAbsent(new Key(type, null), k -> new Capability(type.intern()));
            cap = name == null ? parent : providers.computeIfAbsent(new Key(type, name), k -> {
                Capability ret = new Capability((parent.getName() + "#" + name.toString()).intern());
                parent.addListener(p -> ret.onRegister());
                return ret;
            });
        }
        if (registering) {
            if (name != null) {
                CapabilityManager.error("Cannot register capability type " + type + " + with a name: " + String.valueOf(name));
            }
            object = cap;
            synchronized (object) {
                if (cap.isRegistered()) {
                    CapabilityManager.error("Cannot register capability type " + type + " multiple times");
                }
                cap.onRegister();
            }
        }
        return cap;
    }

    @ApiStatus.Internal
    public static void injectCapabilities(ModList modlist) {
        List<Type> autos = modlist.getAllScanData().stream().flatMap(e -> e.getAnnotations().stream()).filter(a -> AUTO_REGISTER.equals((Object)a.annotationType())).map(ModFileScanData.AnnotationData::clazz).distinct().sorted(Comparator.comparing(Type::toString)).toList();
        for (Type auto : autos) {
            LOGGER.debug(Logging.CAPABILITIES, "Attempting to automatically register: " + String.valueOf(auto));
            CapabilityManager.get(auto.getInternalName(), null, true);
        }
        RegisterCapabilitiesEvent event = (RegisterCapabilitiesEvent)RegisterCapabilitiesEvent.BUS.fire((Event)new RegisterCapabilitiesEvent());
    }

    private static void error(String message) {
        LOGGER.error(Logging.CAPABILITIES, message);
        throw new IllegalStateException(message);
    }

    private record Key(String type, ResourceLocation name) {
    }
}

