/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Collection;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.data.tags.BlockItemTagsProvider;
import net.minecraft.data.tags.TagAppender;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ForgeBlockItemTagsProvider
extends BlockItemTagsProvider {
    protected void run() {
        this.tag(Tags.Blocks.BARRELS, Tags.Items.BARRELS).addTag(Tags.Blocks.BARRELS_WOODEN).addOptionalTag(Legacy.Blocks.BARRELS);
        this.tag(Tags.Blocks.BARRELS_WOODEN, Tags.Items.BARRELS_WOODEN, Legacy.Blocks.BARRELS_WOODEN, Legacy.Items.BARRELS_WOODEN).add((Object)Blocks.BARREL).addOptionalTag(Legacy.Blocks.BARRELS_WOODEN);
        this.tag(Tags.Blocks.BOOKSHELVES, Tags.Items.BOOKSHELVES, Legacy.Blocks.BOOKSHELVES, Legacy.Items.BOOKSHELVES).add((Object)Blocks.BOOKSHELF).addOptionalTag(Legacy.Blocks.BOOKSHELVES);
        this.tag(Tags.Blocks.BUDDING_BLOCKS, Tags.Items.BUDDING_BLOCKS).add((Object)Blocks.BUDDING_AMETHYST);
        this.tag(Tags.Blocks.BUDS, Tags.Items.BUDS).add((Object)Blocks.SMALL_AMETHYST_BUD).add((Object)Blocks.MEDIUM_AMETHYST_BUD).add((Object)Blocks.LARGE_AMETHYST_BUD);
        this.tag(Tags.Blocks.CHAINS, Tags.Items.CHAINS).add((Object)Blocks.IRON_CHAIN).addAll((Collection)Blocks.COPPER_CHAIN.asList());
        this.tag(Tags.Blocks.CHESTS, Tags.Items.CHESTS).addTags(new TagKey[]{Tags.Blocks.CHESTS_ENDER, Tags.Blocks.CHESTS_TRAPPED, Tags.Blocks.CHESTS_WOODEN}).addOptionalTag(Legacy.Blocks.CHESTS);
        this.tag(Tags.Blocks.CHESTS_ENDER, Tags.Items.CHESTS_ENDER).add((Object)Blocks.ENDER_CHEST);
        this.tag(Tags.Blocks.CHESTS_TRAPPED, Tags.Items.CHESTS_TRAPPED).add((Object)Blocks.TRAPPED_CHEST);
        this.tag(Tags.Blocks.CHESTS_WOODEN, Tags.Items.CHESTS_WOODEN, Legacy.Blocks.CHESTS_WOODEN, Legacy.Items.CHESTS_WOODEN).add((Object[])new Block[]{Blocks.CHEST, Blocks.TRAPPED_CHEST}).addOptionalTag(Legacy.Blocks.CHESTS_WOODEN);
        this.tag(Tags.Blocks.CLUSTERS, Tags.Items.CLUSTERS).add((Object)Blocks.AMETHYST_CLUSTER);
        this.tag(Tags.Blocks.COBBLESTONES, Tags.Items.COBBLESTONES, Legacy.Blocks.COBBLESTONE, Legacy.Items.COBBLESTONE).addTags(new TagKey[]{Tags.Blocks.COBBLESTONE_NORMAL, Tags.Blocks.COBBLESTONE_INFESTED, Tags.Blocks.COBBLESTONE_MOSSY, Tags.Blocks.COBBLESTONE_DEEPSLATE}).addOptionalTag(Legacy.Blocks.COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_NORMAL, Tags.Items.COBBLESTONE_NORMAL).add((Object)Blocks.COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_INFESTED, Tags.Items.COBBLESTONE_INFESTED).add((Object)Blocks.INFESTED_COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_MOSSY, Tags.Items.COBBLESTONE_MOSSY).add((Object)Blocks.MOSSY_COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_DEEPSLATE, Tags.Items.COBBLESTONE_DEEPSLATE).add((Object)Blocks.COBBLED_DEEPSLATE);
        this.tag(Tags.Blocks.CONCRETES, Tags.Items.CONCRETES).add((Object[])new Block[]{Blocks.WHITE_CONCRETE, Blocks.ORANGE_CONCRETE, Blocks.MAGENTA_CONCRETE, Blocks.LIGHT_BLUE_CONCRETE, Blocks.YELLOW_CONCRETE, Blocks.LIME_CONCRETE, Blocks.PINK_CONCRETE, Blocks.GRAY_CONCRETE, Blocks.LIGHT_GRAY_CONCRETE, Blocks.CYAN_CONCRETE, Blocks.PURPLE_CONCRETE, Blocks.BLUE_CONCRETE, Blocks.BROWN_CONCRETE, Blocks.GREEN_CONCRETE, Blocks.RED_CONCRETE, Blocks.BLACK_CONCRETE});
        this.tag(Tags.Blocks.END_STONES, Tags.Items.END_STONES).add((Object)Blocks.END_STONE);
        this.tag(Tags.Blocks.FENCE_GATES, Tags.Items.FENCE_GATES).addTags(new TagKey[]{Tags.Blocks.FENCE_GATES_WOODEN});
        this.tag(Tags.Blocks.FENCE_GATES_WOODEN, Tags.Items.FENCE_GATES_WOODEN).add((Object[])new Block[]{Blocks.OAK_FENCE_GATE, Blocks.SPRUCE_FENCE_GATE, Blocks.BIRCH_FENCE_GATE, Blocks.JUNGLE_FENCE_GATE, Blocks.ACACIA_FENCE_GATE, Blocks.DARK_OAK_FENCE_GATE, Blocks.CRIMSON_FENCE_GATE, Blocks.WARPED_FENCE_GATE, Blocks.MANGROVE_FENCE_GATE, Blocks.BAMBOO_FENCE_GATE, Blocks.CHERRY_FENCE_GATE});
        this.tag(Tags.Blocks.FENCES, Tags.Items.FENCES).addTags(new TagKey[]{Tags.Blocks.FENCES_NETHER_BRICK, Tags.Blocks.FENCES_WOODEN});
        this.tag(Tags.Blocks.FENCES_NETHER_BRICK, Tags.Items.FENCES_NETHER_BRICK).add((Object)Blocks.NETHER_BRICK_FENCE);
        this.tag(Tags.Blocks.FENCES_WOODEN, Tags.Items.FENCES_WOODEN).addTag(BlockTags.WOODEN_FENCES);
        this.tag(Tags.Blocks.FLOWERS_SMALL, Tags.Items.FLOWERS_SMALL).add((Object[])new Block[]{Blocks.DANDELION, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.LILY_OF_THE_VALLEY, Blocks.WITHER_ROSE, Blocks.TORCHFLOWER, Blocks.OPEN_EYEBLOSSOM, Blocks.CLOSED_EYEBLOSSOM}).addOptionalTag(BlockTags.SMALL_FLOWERS);
        this.tag(Tags.Blocks.FLOWERS_TALL, Tags.Items.FLOWERS_TALL).add((Object[])new Block[]{Blocks.SUNFLOWER, Blocks.LILAC, Blocks.PEONY, Blocks.ROSE_BUSH, Blocks.PITCHER_PLANT}).addOptionalTag(ForgeBlockItemTagsProvider.tagKey("tall_flowers"));
        this.tag(Tags.Blocks.FLOWERS, Tags.Items.FLOWERS).add((Object[])new Block[]{Blocks.FLOWERING_AZALEA_LEAVES, Blocks.FLOWERING_AZALEA, Blocks.MANGROVE_PROPAGULE, Blocks.PINK_PETALS, Blocks.CHORUS_FLOWER, Blocks.SPORE_BLOSSOM}).addTags(new TagKey[]{Tags.Blocks.FLOWERS_SMALL, Tags.Blocks.FLOWERS_TALL}).addOptionalTag(BlockTags.FLOWERS);
        this.tag(Tags.Blocks.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS).addTags(new TagKey[]{Tags.Blocks.GLASS_BLOCKS_COLORLESS, Tags.Blocks.GLASS_BLOCKS_CHEAP, Tags.Blocks.GLASS_BLOCKS_TINTED}).addOptionalTag(Tags.Blocks.GLASS);
        this.tag(Tags.Blocks.GLASS_BLOCKS_COLORLESS, Tags.Items.GLASS_BLOCKS_COLORLESS).add((Object)Blocks.GLASS).addOptionalTag(Tags.Blocks.GLASS_COLORLESS);
        this.tag(Tags.Blocks.GLASS_BLOCKS_TINTED, Tags.Items.GLASS_BLOCKS_TINTED).add((Object)Blocks.TINTED_GLASS).addOptionalTag(Legacy.Blocks.GLASS_TINTED);
        this.tag(Tags.Blocks.GLASS_BLOCKS_CHEAP, Tags.Items.GLASS_BLOCKS_CHEAP, Legacy.Blocks.GLASS_SILICA, Legacy.Items.GLASS_SILICA).add((Object[])new Block[]{Blocks.GLASS, Blocks.WHITE_STAINED_GLASS, Blocks.ORANGE_STAINED_GLASS, Blocks.MAGENTA_STAINED_GLASS, Blocks.LIGHT_BLUE_STAINED_GLASS, Blocks.YELLOW_STAINED_GLASS, Blocks.LIME_STAINED_GLASS, Blocks.PINK_STAINED_GLASS, Blocks.GRAY_STAINED_GLASS, Blocks.LIGHT_GRAY_STAINED_GLASS, Blocks.CYAN_STAINED_GLASS, Blocks.PURPLE_STAINED_GLASS, Blocks.BLUE_STAINED_GLASS, Blocks.BROWN_STAINED_GLASS, Blocks.GREEN_STAINED_GLASS, Blocks.RED_STAINED_GLASS, Blocks.BLACK_STAINED_GLASS}).addOptionalTag(Legacy.Blocks.GLASS_SILICA);
        this.tag(Tags.Blocks.GLASS_PANES, Tags.Items.GLASS_PANES).addTags(new TagKey[]{Tags.Blocks.GLASS_PANES_COLORLESS}).add((Object[])new Block[]{Blocks.WHITE_STAINED_GLASS_PANE, Blocks.ORANGE_STAINED_GLASS_PANE, Blocks.MAGENTA_STAINED_GLASS_PANE, Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, Blocks.YELLOW_STAINED_GLASS_PANE, Blocks.LIME_STAINED_GLASS_PANE, Blocks.PINK_STAINED_GLASS_PANE, Blocks.GRAY_STAINED_GLASS_PANE, Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, Blocks.CYAN_STAINED_GLASS_PANE, Blocks.PURPLE_STAINED_GLASS_PANE, Blocks.BLUE_STAINED_GLASS_PANE, Blocks.BROWN_STAINED_GLASS_PANE, Blocks.GREEN_STAINED_GLASS_PANE, Blocks.RED_STAINED_GLASS_PANE, Blocks.BLACK_STAINED_GLASS_PANE}).addOptionalTag(Legacy.Blocks.GLASS_PANES);
        this.tag(Tags.Blocks.GLASS_PANES_COLORLESS, Tags.Items.GLASS_PANES_COLORLESS).add((Object)Blocks.GLASS_PANE).addOptionalTag(ForgeBlockItemTagsProvider.forgeTagKey("glass_panes/colorless"));
        this.tag(Tags.Blocks.GLAZED_TERRACOTTAS, Tags.Items.GLAZED_TERRACOTTAS).add((Object[])new Block[]{Blocks.WHITE_GLAZED_TERRACOTTA, Blocks.ORANGE_GLAZED_TERRACOTTA, Blocks.MAGENTA_GLAZED_TERRACOTTA, Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA, Blocks.YELLOW_GLAZED_TERRACOTTA, Blocks.LIME_GLAZED_TERRACOTTA, Blocks.PINK_GLAZED_TERRACOTTA, Blocks.GRAY_GLAZED_TERRACOTTA, Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA, Blocks.CYAN_GLAZED_TERRACOTTA, Blocks.PURPLE_GLAZED_TERRACOTTA, Blocks.BLUE_GLAZED_TERRACOTTA, Blocks.BROWN_GLAZED_TERRACOTTA, Blocks.GREEN_GLAZED_TERRACOTTA, Blocks.RED_GLAZED_TERRACOTTA, Blocks.BLACK_GLAZED_TERRACOTTA});
        this.tag(Tags.Blocks.GRAVEL, Tags.Items.GRAVEL).add((Object)Blocks.GRAVEL);
        this.tag(Tags.Blocks.NETHERRACK, Tags.Items.NETHERRACK).add((Object)Blocks.NETHERRACK);
        this.tag(Tags.Blocks.OBSIDIANS, Tags.Items.OBSIDIANS).addTags(new TagKey[]{Tags.Blocks.OBSIDIANS_NORMAL, Tags.Blocks.OBSIDIANS_CRYING}).addOptionalTag(Legacy.Blocks.OBSIDIAN);
        this.tag(Tags.Blocks.OBSIDIANS_NORMAL, Tags.Items.OBSIDIANS_NORMAL).add((Object)Blocks.OBSIDIAN);
        this.tag(Tags.Blocks.OBSIDIANS_CRYING, Tags.Items.OBSIDIANS_CRYING).add((Object)Blocks.CRYING_OBSIDIAN);
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE, Tags.Items.ORE_BEARING_GROUND_DEEPSLATE).add((Object)Blocks.DEEPSLATE);
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_NETHERRACK, Tags.Items.ORE_BEARING_GROUND_NETHERRACK).add((Object)Blocks.NETHERRACK);
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_STONE, Tags.Items.ORE_BEARING_GROUND_STONE).add((Object)Blocks.STONE);
        this.tag(Tags.Blocks.ORE_RATES_DENSE, Tags.Items.ORE_RATES_DENSE).add((Object[])new Block[]{Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.DEEPSLATE_REDSTONE_ORE, Blocks.LAPIS_ORE, Blocks.REDSTONE_ORE});
        this.tag(Tags.Blocks.ORE_RATES_SINGULAR, Tags.Items.ORE_RATES_SINGULAR).add((Object[])new Block[]{Blocks.ANCIENT_DEBRIS, Blocks.COAL_ORE, Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.NETHER_QUARTZ_ORE});
        this.tag(Tags.Blocks.ORE_RATES_SPARSE, Tags.Items.ORE_RATES_SPARSE).add((Object)Blocks.NETHER_GOLD_ORE);
        this.tag(Tags.Blocks.ORES, Tags.Items.ORES).addTags(new TagKey[]{Tags.Blocks.ORES_COAL, Tags.Blocks.ORES_COPPER, Tags.Blocks.ORES_DIAMOND, Tags.Blocks.ORES_EMERALD, Tags.Blocks.ORES_GOLD, Tags.Blocks.ORES_IRON, Tags.Blocks.ORES_LAPIS, Tags.Blocks.ORES_NETHERITE_SCRAP, Tags.Blocks.ORES_REDSTONE, Tags.Blocks.ORES_QUARTZ}).addOptionalTag(Legacy.Blocks.ORES);
        this.tag(Tags.Blocks.ORES_COAL, Tags.Items.ORES_COAL).addTag(BlockTags.COAL_ORES);
        this.tag(Tags.Blocks.ORES_COPPER, Tags.Items.ORES_COPPER).addTag(BlockTags.COPPER_ORES);
        this.tag(Tags.Blocks.ORES_DIAMOND, Tags.Items.ORES_DIAMOND).addTag(BlockTags.DIAMOND_ORES);
        this.tag(Tags.Blocks.ORES_EMERALD, Tags.Items.ORES_EMERALD).addTag(BlockTags.EMERALD_ORES);
        this.tag(Tags.Blocks.ORES_GOLD, Tags.Items.ORES_GOLD).addTag(BlockTags.GOLD_ORES);
        this.tag(Tags.Blocks.ORES_IRON, Tags.Items.ORES_IRON).addTag(BlockTags.IRON_ORES);
        this.tag(Tags.Blocks.ORES_LAPIS, Tags.Items.ORES_LAPIS).addTag(BlockTags.LAPIS_ORES);
        this.tag(Tags.Blocks.ORES_QUARTZ, Tags.Items.ORES_QUARTZ, Legacy.Blocks.ORES_QUARTZ, Legacy.Items.QUARTZ_ORES).add((Object)Blocks.NETHER_QUARTZ_ORE).addOptionalTag(Legacy.Blocks.ORES_QUARTZ);
        this.tag(Tags.Blocks.ORES_REDSTONE, Tags.Items.ORES_REDSTONE).addTag(BlockTags.REDSTONE_ORES);
        this.tag(Tags.Blocks.ORES_NETHERITE_SCRAP, Tags.Items.ORES_NETHERITE_SCRAP, Legacy.Blocks.ORES_NETHERITE_SCRAP, Legacy.Items.ORES_NEHTERITE_SCRAP).add((Object)Blocks.ANCIENT_DEBRIS).addOptionalTag(Legacy.Blocks.ORES_NETHERITE_SCRAP);
        this.tag(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE, Tags.Items.ORES_IN_GROUND_DEEPSLATE).add((Object[])new Block[]{Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.DEEPSLATE_REDSTONE_ORE});
        this.tag(Tags.Blocks.ORES_IN_GROUND_NETHERRACK, Tags.Items.ORES_IN_GROUND_NETHERRACK).add((Object[])new Block[]{Blocks.NETHER_GOLD_ORE, Blocks.NETHER_QUARTZ_ORE});
        this.tag(Tags.Blocks.ORES_IN_GROUND_STONE, Tags.Items.ORES_IN_GROUND_STONE).add((Object[])new Block[]{Blocks.COAL_ORE, Blocks.COPPER_ORE, Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.LAPIS_ORE, Blocks.REDSTONE_ORE});
        this.tag(Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES, Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES).add((Object)Blocks.CRAFTING_TABLE);
        this.tag(Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES, Tags.Items.PLAYER_WORKSTATIONS_FURNACES).add((Object)Blocks.FURNACE);
        this.tag(Tags.Blocks.PUMPKINS, Tags.Items.PUMPKINS).addTags(new TagKey[]{Tags.Blocks.PUMPKINS_NORMAL, Tags.Blocks.PUMPKINS_CARVED, Tags.Blocks.PUMPKINS_JACK_O_LANTERNS});
        this.tag(Tags.Blocks.PUMPKINS_NORMAL, Tags.Items.PUMPKINS_NORMAL).add((Object)Blocks.PUMPKIN);
        this.tag(Tags.Blocks.PUMPKINS_CARVED, Tags.Items.PUMPKINS_CARVED).add((Object)Blocks.CARVED_PUMPKIN);
        this.tag(Tags.Blocks.PUMPKINS_JACK_O_LANTERNS, Tags.Items.PUMPKINS_JACK_O_LANTERNS).add((Object)Blocks.JACK_O_LANTERN);
        this.tag(Tags.Blocks.ROPES, Tags.Items.ROPES);
        this.tag(Tags.Blocks.SAND, Tags.Items.SAND).addTags(new TagKey[]{Tags.Blocks.SAND_COLORLESS, Tags.Blocks.SAND_RED});
        this.tag(Tags.Blocks.SAND_COLORLESS, Tags.Items.SAND_COLORLESS).add((Object)Blocks.SAND);
        this.tag(Tags.Blocks.SAND_RED, Tags.Items.SAND_RED).add((Object)Blocks.RED_SAND);
        this.tag(Tags.Blocks.SANDSTONE_BLOCKS, Tags.Items.SANDSTONE_BLOCKS).addTags(new TagKey[]{Tags.Blocks.SANDSTONE_RED_BLOCKS, Tags.Blocks.SANDSTONE_UNCOLORED_BLOCKS}).addOptionalTag(Legacy.Blocks.SANDSTONE);
        this.tag(Tags.Blocks.SANDSTONE_SLABS, Tags.Items.SANDSTONE_SLABS).addTags(new TagKey[]{Tags.Blocks.SANDSTONE_RED_SLABS, Tags.Blocks.SANDSTONE_UNCOLORED_SLABS});
        this.tag(Tags.Blocks.SANDSTONE_STAIRS, Tags.Items.SANDSTONE_STAIRS).addTags(new TagKey[]{Tags.Blocks.SANDSTONE_RED_STAIRS, Tags.Blocks.SANDSTONE_UNCOLORED_STAIRS});
        this.tag(Tags.Blocks.SANDSTONE_RED_BLOCKS, Tags.Items.SANDSTONE_RED_BLOCKS).add((Object[])new Block[]{Blocks.RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE, Blocks.SMOOTH_RED_SANDSTONE});
        this.tag(Tags.Blocks.SANDSTONE_RED_SLABS, Tags.Items.SANDSTONE_RED_SLABS).add((Object[])new Block[]{Blocks.RED_SANDSTONE_SLAB, Blocks.CUT_RED_SANDSTONE_SLAB, Blocks.SMOOTH_RED_SANDSTONE_SLAB});
        this.tag(Tags.Blocks.SANDSTONE_RED_STAIRS, Tags.Items.SANDSTONE_RED_STAIRS).add((Object[])new Block[]{Blocks.RED_SANDSTONE_STAIRS, Blocks.SMOOTH_RED_SANDSTONE_STAIRS});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_BLOCKS, Tags.Items.SANDSTONE_UNCOLORED_BLOCKS).add((Object[])new Block[]{Blocks.SANDSTONE, Blocks.CUT_SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.SMOOTH_SANDSTONE});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_SLABS, Tags.Items.SANDSTONE_UNCOLORED_SLABS).add((Object[])new Block[]{Blocks.SANDSTONE_SLAB, Blocks.CUT_SANDSTONE_SLAB, Blocks.SMOOTH_SANDSTONE_SLAB});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_STAIRS, Tags.Items.SANDSTONE_UNCOLORED_STAIRS).add((Object[])new Block[]{Blocks.SANDSTONE_STAIRS, Blocks.SMOOTH_SANDSTONE_STAIRS});
        this.tag(Tags.Blocks.STONES, Tags.Items.STONES).add((Object[])new Block[]{Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.STONE, Blocks.DEEPSLATE, Blocks.TUFF});
        this.tag(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS).addTags(new TagKey[]{Tags.Blocks.STORAGE_BLOCKS_BONE_MEAL, Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Blocks.STORAGE_BLOCKS_COPPER, Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Blocks.STORAGE_BLOCKS_DRIED_KELP, Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Blocks.STORAGE_BLOCKS_NETHERITE, Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD, Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Blocks.STORAGE_BLOCKS_SLIME, Tags.Blocks.STORAGE_BLOCKS_WHEAT}).addOptionalTags(new TagKey[]{Legacy.Blocks.STORAGE_BLOCKS_COAL, Legacy.Blocks.STORAGE_BLOCKS_COPPER, Legacy.Blocks.STORAGE_BLOCKS_DIAMOND, Legacy.Blocks.STORAGE_BLOCKS_EMERALD, Legacy.Blocks.STORAGE_BLOCKS_GOLD, Legacy.Blocks.STORAGE_BLOCKS_IRON, Legacy.Blocks.STORAGE_BLOCKS_LAPIS, Legacy.Blocks.STORAGE_BLOCKS_NETHERITE, Legacy.Blocks.STORAGE_BLOCKS_RAW_COPPER, Legacy.Blocks.STORAGE_BLOCKS_RAW_GOLD, Legacy.Blocks.STORAGE_BLOCKS_RAW_IRON, Legacy.Blocks.STORAGE_BLOCKS_REDSTONE});
        this.tag(Tags.Blocks.STORAGE_BLOCKS_AMETHYST, Tags.Items.STORAGE_BLOCKS_AMETHYST).add((Object)Blocks.AMETHYST_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_BONE_MEAL, Tags.Items.STORAGE_BLOCKS_BONE_MEAL).add((Object)Blocks.BONE_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Items.STORAGE_BLOCKS_COAL, Legacy.Blocks.STORAGE_BLOCKS_COAL, Legacy.Items.STORAGE_BLOCKS_COAL).add((Object)Blocks.COAL_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_COAL);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_COPPER, Tags.Items.STORAGE_BLOCKS_COPPER, Legacy.Blocks.STORAGE_BLOCKS_COPPER, Legacy.Items.STORAGE_BLOCKS_COPPER).add((Object)Blocks.COPPER_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_COPPER);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Items.STORAGE_BLOCKS_DIAMOND, Legacy.Blocks.STORAGE_BLOCKS_DIAMOND, Legacy.Items.STORAGE_BLOCKS_DIAMOND).add((Object)Blocks.DIAMOND_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_DIAMOND);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_DRIED_KELP, Tags.Items.STORAGE_BLOCKS_DRIED_KELP).add((Object)Blocks.DRIED_KELP_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Items.STORAGE_BLOCKS_EMERALD, Legacy.Blocks.STORAGE_BLOCKS_EMERALD, Legacy.Items.STORAGE_BLOCKS_EMERALD).add((Object)Blocks.EMERALD_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_EMERALD);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Items.STORAGE_BLOCKS_GOLD, Legacy.Blocks.STORAGE_BLOCKS_GOLD, Legacy.Items.STORAGE_BLOCKS_GOLD).add((Object)Blocks.GOLD_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_GOLD);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Items.STORAGE_BLOCKS_IRON, Legacy.Blocks.STORAGE_BLOCKS_IRON, Legacy.Items.STORAGE_BLOCKS_IRON).add((Object)Blocks.IRON_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_IRON);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Items.STORAGE_BLOCKS_LAPIS, Legacy.Blocks.STORAGE_BLOCKS_LAPIS, Legacy.Items.STORAGE_BLOCKS_LAPIS).add((Object)Blocks.LAPIS_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_LAPIS);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_NETHERITE, Tags.Items.STORAGE_BLOCKS_NETHERITE, Legacy.Blocks.STORAGE_BLOCKS_NETHERITE, Legacy.Items.STORAGE_BLOCKS_NETHERITE).add((Object)Blocks.NETHERITE_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_NETHERITE);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Items.STORAGE_BLOCKS_QUARTZ).add((Object)Blocks.QUARTZ_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, Tags.Items.STORAGE_BLOCKS_RAW_COPPER, Legacy.Blocks.STORAGE_BLOCKS_RAW_COPPER, Legacy.Items.STORAGE_BLOCKS_RAW_COPPER).add((Object)Blocks.RAW_COPPER_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_RAW_COPPER);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD, Tags.Items.STORAGE_BLOCKS_RAW_GOLD, Legacy.Blocks.STORAGE_BLOCKS_RAW_GOLD, Legacy.Items.STORAGE_BLOCKS_RAW_GOLD).add((Object)Blocks.RAW_GOLD_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_RAW_GOLD);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, Tags.Items.STORAGE_BLOCKS_RAW_IRON, Legacy.Blocks.STORAGE_BLOCKS_RAW_IRON, Legacy.Items.STORAGE_BLOCKS_RAW_IRON).add((Object)Blocks.RAW_IRON_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_RAW_IRON);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Items.STORAGE_BLOCKS_REDSTONE, Legacy.Blocks.STORAGE_BLOCKS_REDSTONE, Legacy.Items.STORAGE_BLOCKS_REDSTONE).add((Object)Blocks.REDSTONE_BLOCK).addOptionalTag(Legacy.Blocks.STORAGE_BLOCKS_REDSTONE);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_SLIME, Tags.Items.STORAGE_BLOCKS_SLIME).add((Object)Blocks.SLIME_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_WHEAT, Tags.Items.STORAGE_BLOCKS_WHEAT).add((Object)Blocks.HAY_BLOCK);
        this.tag(Tags.Blocks.STRIPPED_LOGS, Tags.Items.STRIPPED_LOGS).add((Object[])new Block[]{Blocks.STRIPPED_ACACIA_LOG, Blocks.STRIPPED_BAMBOO_BLOCK, Blocks.STRIPPED_BIRCH_LOG, Blocks.STRIPPED_CHERRY_LOG, Blocks.STRIPPED_DARK_OAK_LOG, Blocks.STRIPPED_JUNGLE_LOG, Blocks.STRIPPED_MANGROVE_LOG, Blocks.STRIPPED_OAK_LOG, Blocks.STRIPPED_SPRUCE_LOG});
        this.tag(Tags.Blocks.STRIPPED_WOODS, Tags.Items.STRIPPED_WOODS).add((Object[])new Block[]{Blocks.STRIPPED_ACACIA_WOOD, Blocks.STRIPPED_BIRCH_WOOD, Blocks.STRIPPED_CHERRY_WOOD, Blocks.STRIPPED_DARK_OAK_WOOD, Blocks.STRIPPED_JUNGLE_WOOD, Blocks.STRIPPED_MANGROVE_WOOD, Blocks.STRIPPED_OAK_WOOD, Blocks.STRIPPED_SPRUCE_WOOD});
        this.tag(Legacy.Blocks.BARRELS, Legacy.Items.BARRELS).addTag(Legacy.Blocks.BARRELS_WOODEN);
        this.tag(Legacy.Blocks.CHESTS, Legacy.Items.CHESTS).addTags(new TagKey[]{Tags.Blocks.CHESTS_ENDER, Tags.Blocks.CHESTS_TRAPPED, Legacy.Blocks.CHESTS_WOODEN});
        this.addColored(arg_0 -> ((TagAppender)this.tag(Tags.Blocks.STAINED_GLASS, Tags.Items.STAINED_GLASS)).add(arg_0), Tags.Blocks.GLASS, "{color}_stained_glass");
        this.addColored(arg_0 -> ((TagAppender)this.tag(Tags.Blocks.STAINED_GLASS_PANES, Tags.Items.STAINED_GLASS_PANES)).add(arg_0), Tags.Blocks.GLASS_PANES, "{color}_stained_glass_pane");
        this.tag(Tags.Blocks.GLASS, Tags.Items.GLASS).addTags(new TagKey[]{Tags.Blocks.GLASS_COLORLESS, Tags.Blocks.STAINED_GLASS, Legacy.Blocks.GLASS_TINTED});
        this.tag(Tags.Blocks.GLASS_COLORLESS, Tags.Items.GLASS_COLORLESS).add((Object)Blocks.GLASS);
        this.tag(Legacy.Blocks.GLASS_PANES, Legacy.Items.GLASS_PANES).addTags(new TagKey[]{Legacy.Blocks.GLASS_PANES_COLORLESS, Tags.Blocks.STAINED_GLASS_PANES});
        this.tag(Legacy.Blocks.GLASS_PANES_COLORLESS, Legacy.Items.GLASS_PANES_COLORLESS).add((Object)Blocks.GLASS_PANE);
        this.tag(Legacy.Blocks.GLASS_TINTED, Legacy.Items.GLASS_TINTED).add((Object)Blocks.TINTED_GLASS);
        this.tag(Legacy.Blocks.OBSIDIAN, Legacy.Items.OBSIDIAN).add((Object)Blocks.OBSIDIAN);
        this.tag(Legacy.Blocks.ORES, Legacy.Items.ORES).addTags(new TagKey[]{Tags.Blocks.ORES_COAL, Tags.Blocks.ORES_COPPER, Tags.Blocks.ORES_DIAMOND, Tags.Blocks.ORES_EMERALD, Tags.Blocks.ORES_GOLD, Tags.Blocks.ORES_IRON, Tags.Blocks.ORES_LAPIS, Tags.Blocks.ORES_REDSTONE, Legacy.Blocks.ORES_QUARTZ, Legacy.Blocks.ORES_NETHERITE_SCRAP});
        this.tag(Legacy.Blocks.SANDSTONE, Legacy.Items.SANDSTONE).add((Object[])new Block[]{Blocks.SANDSTONE, Blocks.CUT_SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.SMOOTH_SANDSTONE, Blocks.RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE, Blocks.SMOOTH_RED_SANDSTONE});
        this.tag(Legacy.Blocks.STONE, Legacy.Items.STONE).add((Object[])new Block[]{Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.INFESTED_STONE, Blocks.STONE, Blocks.POLISHED_ANDESITE, Blocks.POLISHED_DIORITE, Blocks.POLISHED_GRANITE, Blocks.DEEPSLATE, Blocks.POLISHED_DEEPSLATE, Blocks.INFESTED_DEEPSLATE, Blocks.TUFF});
        this.tag(Legacy.Blocks.STORAGE_BLOCKS, Legacy.Items.STORAGE_BLOCKS).addTags(new TagKey[]{Tags.Blocks.STORAGE_BLOCKS_AMETHYST, Legacy.Blocks.STORAGE_BLOCKS_COAL, Legacy.Blocks.STORAGE_BLOCKS_COPPER, Legacy.Blocks.STORAGE_BLOCKS_DIAMOND, Legacy.Blocks.STORAGE_BLOCKS_EMERALD, Legacy.Blocks.STORAGE_BLOCKS_GOLD, Legacy.Blocks.STORAGE_BLOCKS_IRON, Legacy.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Legacy.Blocks.STORAGE_BLOCKS_RAW_COPPER, Legacy.Blocks.STORAGE_BLOCKS_RAW_GOLD, Legacy.Blocks.STORAGE_BLOCKS_RAW_IRON, Legacy.Blocks.STORAGE_BLOCKS_REDSTONE, Legacy.Blocks.STORAGE_BLOCKS_NETHERITE});
    }

    private static TagKey<Block> forgeTagKey(String path) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path));
    }

    private static TagKey<Block> tagKey(String name) {
        return BlockTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    private void addColored(Consumer<Block> consumer, TagKey<Block> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)pattern.replace("{color}", color.getName()));
            TagKey blockTag = ForgeBlockItemTagsProvider.getForgeTag(Tags.Blocks.class, prefix + color.getName());
            TagKey itemTag = ForgeBlockItemTagsProvider.getForgeTag(Tags.Items.class, prefix + color.getName());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.AIR) {
                throw new IllegalStateException("Unknown vanilla block: " + key.toString());
            }
            this.tag(blockTag, itemTag).add((Object)block);
            consumer.accept(block);
        }
    }

    private static <T> TagKey<T> getForgeTag(Class<?> cls, String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (TagKey)cls.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(cls.getName() + " is missing tag name: " + name);
        }
    }

    private static ResourceLocation forgeRl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path);
    }

    private TagAppender<Block, Block> tag(TagKey<Block> block, TagKey<Item> item, TagKey<Block> oldBlock, TagKey<Item> oldItem) {
        TagAppender tag = this.tag(block, item);
        TagAppender old = this.tag(oldBlock, oldItem);
        return ForgeBlockItemTagsProvider.wrap((TagAppender<Block, Block>)tag, (TagAppender<Block, Block>)old, oldBlock);
    }

    private static TagAppender<Block, Block> wrap(final TagAppender<Block, Block> tag, final TagAppender<Block, Block> old, final TagKey<Block> oldBlock) {
        return new TagAppender<Block, Block>(){

            public TagAppender<Block, Block> add(Block value) {
                tag.add((Object)value);
                old.add((Object)value);
                return this;
            }

            public TagAppender<Block, Block> addOptional(Block value) {
                tag.addOptional((Object)value);
                old.addOptional((Object)value);
                return this;
            }

            public TagAppender<Block, Block> addTag(TagKey<Block> value) {
                tag.addTag(value);
                old.addTag(value);
                return this;
            }

            public TagAppender<Block, Block> addOptionalTag(TagKey<Block> value) {
                tag.addOptionalTag(value);
                if (value != oldBlock) {
                    old.addOptionalTag(value);
                }
                return this;
            }

            public TagAppender<Block, Block> replace(boolean value) {
                tag.replace(value);
                old.replace(value);
                return this;
            }

            public TagAppender<Block, Block> remove(ResourceLocation value) {
                tag.remove(value);
                old.remove(value);
                return this;
            }

            public TagAppender<Block, Block> remove(TagKey<Block> value) {
                tag.remove(value);
                old.remove(value);
                return this;
            }

            public TagAppender<Block, Block> remove(Block value) {
                tag.remove((Object)value);
                old.remove((Object)value);
                return this;
            }

            public String getSourceName() {
                return tag.getSourceName();
            }
        };
    }

    private static class Legacy {
        private Legacy() {
        }

        @Deprecated
        private static class Items {
            public static final TagKey<Item> BARRELS = Items.tag("barrels");
            public static final TagKey<Item> BARRELS_WOODEN = Items.tag("barrels/wooden");
            public static final TagKey<Item> BOOKSHELVES = Items.tag("bookshelves");
            public static final TagKey<Item> CHESTS = Items.tag("chests");
            public static final TagKey<Item> CHESTS_WOODEN = Items.tag("chests/wooden");
            public static final TagKey<Item> COBBLESTONE = Items.tag("cobblestone");
            public static final TagKey<Item> GLASS_PANES = Items.tag("glass_panes");
            public static final TagKey<Item> GLASS_PANES_COLORLESS = Items.tag("glass_panes/colorless");
            public static final TagKey<Item> GLASS_SILICA = Items.tag("glass/silica");
            public static final TagKey<Item> GLASS_TINTED = Items.tag("glass/tinted");
            public static final TagKey<Item> OBSIDIAN = Items.tag("obsidian");
            public static final TagKey<Item> ORES = Items.tag("ores");
            public static final TagKey<Item> QUARTZ_ORES = Items.tag("ores/quartz");
            public static final TagKey<Item> ORES_NEHTERITE_SCRAP = Items.tag("ores/netherite_scrap");
            public static final TagKey<Item> SANDSTONE = Items.tag("sandstone");
            public static final TagKey<Item> STONE = Items.tag("stone");
            public static final TagKey<Item> STORAGE_BLOCKS = Items.tag("storage_blocks");
            public static final TagKey<Item> STORAGE_BLOCKS_COAL = Items.tag("storage_blocks/coal");
            public static final TagKey<Item> STORAGE_BLOCKS_COPPER = Items.tag("storage_blocks/copper");
            public static final TagKey<Item> STORAGE_BLOCKS_DIAMOND = Items.tag("storage_blocks/diamond");
            public static final TagKey<Item> STORAGE_BLOCKS_EMERALD = Items.tag("storage_blocks/emerald");
            public static final TagKey<Item> STORAGE_BLOCKS_GOLD = Items.tag("storage_blocks/gold");
            public static final TagKey<Item> STORAGE_BLOCKS_IRON = Items.tag("storage_blocks/iron");
            public static final TagKey<Item> STORAGE_BLOCKS_LAPIS = Items.tag("storage_blocks/lapis");
            public static final TagKey<Item> STORAGE_BLOCKS_NETHERITE = Items.tag("storage_blocks/netherite");
            public static final TagKey<Item> STORAGE_BLOCKS_RAW_COPPER = Items.tag("storage_blocks/raw_copper");
            public static final TagKey<Item> STORAGE_BLOCKS_RAW_GOLD = Items.tag("storage_blocks/raw_gold");
            public static final TagKey<Item> STORAGE_BLOCKS_RAW_IRON = Items.tag("storage_blocks/raw_iron");
            public static final TagKey<Item> STORAGE_BLOCKS_REDSTONE = Items.tag("storage_blocks/redstone");

            private Items() {
            }

            private static TagKey<Item> tag(String path) {
                return ItemTags.create((ResourceLocation)ForgeBlockItemTagsProvider.forgeRl(path));
            }
        }

        @Deprecated
        private static class Blocks {
            public static final TagKey<Block> BARRELS = Blocks.tag("barrels");
            public static final TagKey<Block> BARRELS_WOODEN = Blocks.tag("barrels/wooden");
            public static final TagKey<Block> BOOKSHELVES = Blocks.tag("bookshelves");
            public static final TagKey<Block> CHESTS = Blocks.tag("chests");
            public static final TagKey<Block> CHESTS_WOODEN = Blocks.tag("chests/wooden");
            public static final TagKey<Block> COBBLESTONE = Blocks.tag("cobblestone");
            public static final TagKey<Block> GLASS_PANES = Blocks.tag("glass_panes");
            public static final TagKey<Block> GLASS_PANES_COLORLESS = Blocks.tag("glass_panes/colorless");
            public static final TagKey<Block> GLASS_SILICA = Blocks.tag("glass/silica");
            public static final TagKey<Block> GLASS_TINTED = Blocks.tag("glass/tinted");
            public static final TagKey<Block> OBSIDIAN = Blocks.tag("obsidian");
            public static final TagKey<Block> ORES = Blocks.tag("ores");
            public static final TagKey<Block> ORES_QUARTZ = Blocks.tag("ores/quartz");
            public static final TagKey<Block> ORES_NETHERITE_SCRAP = Blocks.tag("ores/netherite_scrap");
            public static final TagKey<Block> SANDSTONE = Blocks.tag("sandstone");
            public static final TagKey<Block> STONE = Blocks.tag("stone");
            public static final TagKey<Block> STORAGE_BLOCKS = Blocks.tag("storage_blocks");
            public static final TagKey<Block> STORAGE_BLOCKS_COAL = Blocks.tag("storage_blocks/coal");
            public static final TagKey<Block> STORAGE_BLOCKS_COPPER = Blocks.tag("storage_blocks/copper");
            public static final TagKey<Block> STORAGE_BLOCKS_DIAMOND = Blocks.tag("storage_blocks/diamond");
            public static final TagKey<Block> STORAGE_BLOCKS_EMERALD = Blocks.tag("storage_blocks/emerald");
            public static final TagKey<Block> STORAGE_BLOCKS_GOLD = Blocks.tag("storage_blocks/gold");
            public static final TagKey<Block> STORAGE_BLOCKS_IRON = Blocks.tag("storage_blocks/iron");
            public static final TagKey<Block> STORAGE_BLOCKS_LAPIS = Blocks.tag("storage_blocks/lapis");
            public static final TagKey<Block> STORAGE_BLOCKS_NETHERITE = Blocks.tag("storage_blocks/netherite");
            public static final TagKey<Block> STORAGE_BLOCKS_RAW_COPPER = Blocks.tag("storage_blocks/raw_copper");
            public static final TagKey<Block> STORAGE_BLOCKS_RAW_GOLD = Blocks.tag("storage_blocks/raw_gold");
            public static final TagKey<Block> STORAGE_BLOCKS_RAW_IRON = Blocks.tag("storage_blocks/raw_iron");
            public static final TagKey<Block> STORAGE_BLOCKS_REDSTONE = Blocks.tag("storage_blocks/redstone");

            private Blocks() {
            }

            private static TagKey<Block> tag(String path) {
                return BlockTags.create((ResourceLocation)ForgeBlockItemTagsProvider.forgeRl(path));
            }
        }
    }
}

