/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.util.function.Supplier;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClearableLazy<T>
extends Lazy<T> {
    public void invalidate();

    public static <T> ClearableLazy<T> of(@NotNull Supplier<T> supplier) {
        return new Fast<T>(supplier);
    }

    public static <T> ClearableLazy<T> concurrentOf(@NotNull Supplier<T> supplier) {
        return new Concurrent<T>(supplier);
    }

    public static final class Fast<T>
    implements ClearableLazy<T> {
        private final Supplier<T> supplier;
        private T instance;

        private Fast(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        @Nullable
        public final T get() {
            if (this.instance == null) {
                this.instance = this.supplier.get();
            }
            return this.instance;
        }

        @Override
        public void invalidate() {
            this.instance = null;
        }
    }

    public static final class Concurrent<T>
    implements ClearableLazy<T> {
        private final Object lock = new Object();
        private final Supplier<T> supplier;
        private volatile T instance;

        private Concurrent(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final T get() {
            T ret = this.instance;
            if (ret == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.instance == null) {
                        this.instance = this.supplier.get();
                        return this.instance;
                    }
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            Object object = this.lock;
            synchronized (object) {
                this.instance = null;
            }
        }
    }
}

