/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.brewing;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract sealed class PotionBrewEvent
extends MutableEvent
implements InheritableEvent {
    public static final EventBus<PotionBrewEvent> BUS = EventBus.create(PotionBrewEvent.class);
    private final NonNullList<ItemStack> stacks;

    protected PotionBrewEvent(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public ItemStack getItem(int index) {
        if (index < 0 || index >= this.stacks.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(index);
    }

    public void setItem(int index, ItemStack stack) {
        if (index < this.stacks.size()) {
            this.stacks.set(index, (Object)stack);
        }
    }

    public int getLength() {
        return this.stacks.size();
    }

    public static final class Post
    extends PotionBrewEvent {
        public static final EventBus<Post> BUS = EventBus.create(Post.class);

        public Post(NonNullList<ItemStack> stacks) {
            super(stacks);
        }
    }

    public static final class Pre
    extends PotionBrewEvent
    implements Cancellable {
        public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

        public Pre(NonNullList<ItemStack> stacks) {
            super(stacks);
        }
    }
}

