/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class EntityTeleportEvent
implements Cancellable,
EntityEvent,
InheritableEvent {
    public static final CancellableEventBus<EntityTeleportEvent> BUS = CancellableEventBus.create(EntityTeleportEvent.class);
    private final Entity entity;
    protected double targetX;
    protected double targetY;
    protected double targetZ;

    protected EntityTeleportEvent(Entity entity, double targetX, double targetY, double targetZ) {
        this.entity = entity;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public double getTargetX() {
        return this.targetX;
    }

    public void setTargetX(double targetX) {
        this.targetX = targetX;
    }

    public double getTargetY() {
        return this.targetY;
    }

    public void setTargetY(double targetY) {
        this.targetY = targetY;
    }

    public double getTargetZ() {
        return this.targetZ;
    }

    public void setTargetZ(double targetZ) {
        this.targetZ = targetZ;
    }

    public Vec3 getTarget() {
        return new Vec3(this.targetX, this.targetY, this.targetZ);
    }

    public double getPrevX() {
        return this.getEntity().getX();
    }

    public double getPrevY() {
        return this.getEntity().getY();
    }

    public double getPrevZ() {
        return this.getEntity().getZ();
    }

    public Vec3 getPrev() {
        return this.getEntity().position();
    }

    public static final class ChorusFruit
    extends EntityTeleportEvent {
        public static final CancellableEventBus<ChorusFruit> BUS = CancellableEventBus.create(ChorusFruit.class);
        private final LivingEntity entityLiving;

        public ChorusFruit(LivingEntity entity, double targetX, double targetY, double targetZ) {
            super((Entity)entity, targetX, targetY, targetZ);
            this.entityLiving = entity;
        }

        public LivingEntity getEntityLiving() {
            return this.entityLiving;
        }
    }

    public static final class EnderPearl
    extends EntityTeleportEvent {
        public static final CancellableEventBus<EnderPearl> BUS = CancellableEventBus.create(EnderPearl.class);
        private final ServerPlayer player;
        private final ThrownEnderpearl pearlEntity;
        private float attackDamage;
        private final HitResult hitResult;

        @ApiStatus.Internal
        public EnderPearl(ServerPlayer entity, double targetX, double targetY, double targetZ, ThrownEnderpearl pearlEntity, float attackDamage, HitResult hitResult) {
            super((Entity)entity, targetX, targetY, targetZ);
            this.pearlEntity = pearlEntity;
            this.player = entity;
            this.attackDamage = attackDamage;
            this.hitResult = hitResult;
        }

        public ThrownEnderpearl getPearlEntity() {
            return this.pearlEntity;
        }

        public ServerPlayer getPlayer() {
            return this.player;
        }

        @Nullable
        public HitResult getHitResult() {
            return this.hitResult;
        }

        public float getAttackDamage() {
            return this.attackDamage;
        }

        public void setAttackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
        }
    }

    public static final class EnderEntity
    extends EntityTeleportEvent {
        public static final CancellableEventBus<EnderEntity> BUS = CancellableEventBus.create(EnderEntity.class);
        private final LivingEntity entityLiving;

        public EnderEntity(LivingEntity entity, double targetX, double targetY, double targetZ) {
            super((Entity)entity, targetX, targetY, targetZ);
            this.entityLiving = entity;
        }

        public LivingEntity getEntityLiving() {
            return this.entityLiving;
        }
    }

    public static final class SpreadPlayersCommand
    extends EntityTeleportEvent {
        public static final CancellableEventBus<SpreadPlayersCommand> BUS = CancellableEventBus.create(SpreadPlayersCommand.class);

        public SpreadPlayersCommand(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }
    }

    public static final class TeleportCommand
    extends EntityTeleportEvent {
        public static final CancellableEventBus<TeleportCommand> BUS = CancellableEventBus.create(TeleportCommand.class);

        public TeleportCommand(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }
    }
}

