/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.Nullable;

public final class BabyEntitySpawnEvent
extends MutableEvent
implements Cancellable {
    public static final CancellableEventBus<BabyEntitySpawnEvent> BUS = CancellableEventBus.create(BabyEntitySpawnEvent.class);
    private final Mob parentA;
    private final Mob parentB;
    private final Player causedByPlayer;
    private AgeableMob child;

    public BabyEntitySpawnEvent(Mob parentA, Mob parentB, @Nullable AgeableMob proposedChild) {
        Animal animal;
        ServerPlayer causedByPlayer = null;
        if (parentA instanceof Animal) {
            animal = (Animal)parentA;
            causedByPlayer = animal.getLoveCause();
        }
        if (causedByPlayer == null && parentB instanceof Animal) {
            animal = (Animal)parentB;
            causedByPlayer = animal.getLoveCause();
        }
        this.parentA = parentA;
        this.parentB = parentB;
        this.causedByPlayer = causedByPlayer;
        this.child = proposedChild;
    }

    public Mob getParentA() {
        return this.parentA;
    }

    public Mob getParentB() {
        return this.parentB;
    }

    @Nullable
    public Player getCausedByPlayer() {
        return this.causedByPlayer;
    }

    @Nullable
    public AgeableMob getChild() {
        return this.child;
    }

    public void setChild(AgeableMob proposedChild) {
        this.child = proposedChild;
    }
}

