/*
 * Decompiled with CFR 0.152.
 */
package lzma.sdk.lz;

import java.io.IOException;
import java.io.InputStream;

public class InWindow {
    byte[] _bufferBase;
    private InputStream _stream;
    private int _posLimit;
    private boolean _streamEndWasReached;
    private int _pointerToLastSafePosition;
    int _bufferOffset;
    private int _blockSize;
    int _pos;
    private int _keepSizeBefore;
    private int _keepSizeAfter;
    int _streamPos;

    void moveBlock() {
        int offset = this._bufferOffset + this._pos - this._keepSizeBefore;
        if (offset > 0) {
            --offset;
        }
        int numBytes = this._bufferOffset + this._streamPos - offset;
        System.arraycopy(this._bufferBase, offset, this._bufferBase, 0, numBytes);
        this._bufferOffset -= offset;
    }

    void readBlock() throws IOException {
        if (this._streamEndWasReached) {
            return;
        }
        int size;
        while ((size = 0 - this._bufferOffset + this._blockSize - this._streamPos) != 0) {
            int numReadBytes = this._stream.read(this._bufferBase, this._bufferOffset + this._streamPos, size);
            if (numReadBytes == -1) {
                this._posLimit = this._streamPos;
                int pointerToPostion = this._bufferOffset + this._posLimit;
                if (pointerToPostion > this._pointerToLastSafePosition) {
                    this._posLimit = this._pointerToLastSafePosition - this._bufferOffset;
                }
                this._streamEndWasReached = true;
                return;
            }
            this._streamPos += numReadBytes;
            if (this._streamPos < this._pos + this._keepSizeAfter) continue;
            this._posLimit = this._streamPos - this._keepSizeAfter;
        }
        return;
    }

    void free() {
        this._bufferBase = null;
    }

    void create(int keepSizeBefore, int keepSizeAfter, int keepSizeReserv) {
        this._keepSizeBefore = keepSizeBefore;
        this._keepSizeAfter = keepSizeAfter;
        int blockSize = keepSizeBefore + keepSizeAfter + keepSizeReserv;
        if (this._bufferBase == null || this._blockSize != blockSize) {
            this.free();
            this._blockSize = blockSize;
            this._bufferBase = new byte[this._blockSize];
        }
        this._pointerToLastSafePosition = this._blockSize - keepSizeAfter;
    }

    public void setStream(InputStream stream) {
        this._stream = stream;
    }

    public void releaseStream() {
        this._stream = null;
    }

    void init() throws IOException {
        this._bufferOffset = 0;
        this._pos = 0;
        this._streamPos = 0;
        this._streamEndWasReached = false;
        this.readBlock();
    }

    void movePos() throws IOException {
        ++this._pos;
        if (this._pos > this._posLimit) {
            int pointerToPostion = this._bufferOffset + this._pos;
            if (pointerToPostion > this._pointerToLastSafePosition) {
                this.moveBlock();
            }
            this.readBlock();
        }
    }

    public byte getIndexByte(int index) {
        return this._bufferBase[this._bufferOffset + this._pos + index];
    }

    public int getMatchLen(int index, int distance, int limit) {
        int i;
        if (this._streamEndWasReached && this._pos + index + limit > this._streamPos) {
            limit = this._streamPos - (this._pos + index);
        }
        ++distance;
        int pby = this._bufferOffset + this._pos + index;
        for (i = 0; i < limit && this._bufferBase[pby + i] == this._bufferBase[pby + i - distance]; ++i) {
        }
        return i;
    }

    public int getNumAvailableBytes() {
        return this._streamPos - this._pos;
    }

    void reduceOffsets(int subValue) {
        this._bufferOffset += subValue;
        this._posLimit -= subValue;
        this._pos -= subValue;
        this._streamPos -= subValue;
    }
}

