/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.nio.pathfs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Function;

class PathFSUtils {
    public static final DirectoryStream<Path> NULL_STREAM = new DirectoryStream<Path>(){

        @Override
        public Iterator<Path> iterator() {
            return new Iterator<Path>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Path next() {
                    return null;
                }
            };
        }

        @Override
        public void close() throws IOException {
        }
    };

    private PathFSUtils() {
    }

    public static DirectoryStream<Path> adapt(final DirectoryStream<Path> inner, final Function<Path, Path> adapter) {
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                final Iterator targetIterator = inner.iterator();
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return targetIterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        Path targetPath = (Path)targetIterator.next();
                        return (Path)adapter.apply(targetPath);
                    }
                };
            }

            @Override
            public void close() throws IOException {
                inner.close();
            }
        };
    }
}

