//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AzureMonitorWorkspacesClient contains the methods for the AzureMonitorWorkspaces group.
// Don't use this type directly, use NewAzureMonitorWorkspacesClient() instead.
type AzureMonitorWorkspacesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAzureMonitorWorkspacesClient creates a new instance of AzureMonitorWorkspacesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAzureMonitorWorkspacesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AzureMonitorWorkspacesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AzureMonitorWorkspacesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Create - Create or update a workspace
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-03-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureMonitorWorkspaceName - The name of the Azure Monitor workspace. The name is case insensitive
//   - azureMonitorWorkspaceProperties - Properties that need to be specified to create a new workspace
//   - options - AzureMonitorWorkspacesClientCreateOptions contains the optional parameters for the AzureMonitorWorkspacesClient.Create
//     method.
func (client *AzureMonitorWorkspacesClient) Create(ctx context.Context, resourceGroupName string, azureMonitorWorkspaceName string, azureMonitorWorkspaceProperties AzureMonitorWorkspaceResource, options *AzureMonitorWorkspacesClientCreateOptions) (AzureMonitorWorkspacesClientCreateResponse, error) {
	var err error
	const operationName = "AzureMonitorWorkspacesClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, azureMonitorWorkspaceName, azureMonitorWorkspaceProperties, options)
	if err != nil {
		return AzureMonitorWorkspacesClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureMonitorWorkspacesClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return AzureMonitorWorkspacesClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *AzureMonitorWorkspacesClient) createCreateRequest(ctx context.Context, resourceGroupName string, azureMonitorWorkspaceName string, azureMonitorWorkspaceProperties AzureMonitorWorkspaceResource, options *AzureMonitorWorkspacesClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/accounts/{azureMonitorWorkspaceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureMonitorWorkspaceName == "" {
		return nil, errors.New("parameter azureMonitorWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureMonitorWorkspaceName}", url.PathEscape(azureMonitorWorkspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-03-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, azureMonitorWorkspaceProperties); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *AzureMonitorWorkspacesClient) createHandleResponse(resp *http.Response) (AzureMonitorWorkspacesClientCreateResponse, error) {
	result := AzureMonitorWorkspacesClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureMonitorWorkspaceResource); err != nil {
		return AzureMonitorWorkspacesClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a workspace
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-03-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureMonitorWorkspaceName - The name of the Azure Monitor workspace. The name is case insensitive
//   - options - AzureMonitorWorkspacesClientDeleteOptions contains the optional parameters for the AzureMonitorWorkspacesClient.Delete
//     method.
func (client *AzureMonitorWorkspacesClient) Delete(ctx context.Context, resourceGroupName string, azureMonitorWorkspaceName string, options *AzureMonitorWorkspacesClientDeleteOptions) (AzureMonitorWorkspacesClientDeleteResponse, error) {
	var err error
	const operationName = "AzureMonitorWorkspacesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, azureMonitorWorkspaceName, options)
	if err != nil {
		return AzureMonitorWorkspacesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureMonitorWorkspacesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return AzureMonitorWorkspacesClientDeleteResponse{}, err
	}
	return AzureMonitorWorkspacesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *AzureMonitorWorkspacesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, azureMonitorWorkspaceName string, options *AzureMonitorWorkspacesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/accounts/{azureMonitorWorkspaceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureMonitorWorkspaceName == "" {
		return nil, errors.New("parameter azureMonitorWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureMonitorWorkspaceName}", url.PathEscape(azureMonitorWorkspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-03-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns the specific Azure Monitor workspace
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-03-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureMonitorWorkspaceName - The name of the Azure Monitor workspace. The name is case insensitive
//   - options - AzureMonitorWorkspacesClientGetOptions contains the optional parameters for the AzureMonitorWorkspacesClient.Get
//     method.
func (client *AzureMonitorWorkspacesClient) Get(ctx context.Context, resourceGroupName string, azureMonitorWorkspaceName string, options *AzureMonitorWorkspacesClientGetOptions) (AzureMonitorWorkspacesClientGetResponse, error) {
	var err error
	const operationName = "AzureMonitorWorkspacesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, azureMonitorWorkspaceName, options)
	if err != nil {
		return AzureMonitorWorkspacesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureMonitorWorkspacesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureMonitorWorkspacesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AzureMonitorWorkspacesClient) getCreateRequest(ctx context.Context, resourceGroupName string, azureMonitorWorkspaceName string, options *AzureMonitorWorkspacesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/accounts/{azureMonitorWorkspaceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureMonitorWorkspaceName == "" {
		return nil, errors.New("parameter azureMonitorWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureMonitorWorkspaceName}", url.PathEscape(azureMonitorWorkspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-03-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AzureMonitorWorkspacesClient) getHandleResponse(resp *http.Response) (AzureMonitorWorkspacesClientGetResponse, error) {
	result := AzureMonitorWorkspacesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureMonitorWorkspaceResource); err != nil {
		return AzureMonitorWorkspacesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Lists all workspaces in the specified resource group
//
// Generated from API version 2021-06-03-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - AzureMonitorWorkspacesClientListByResourceGroupOptions contains the optional parameters for the AzureMonitorWorkspacesClient.NewListByResourceGroupPager
//     method.
func (client *AzureMonitorWorkspacesClient) NewListByResourceGroupPager(resourceGroupName string, options *AzureMonitorWorkspacesClientListByResourceGroupOptions) *runtime.Pager[AzureMonitorWorkspacesClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureMonitorWorkspacesClientListByResourceGroupResponse]{
		More: func(page AzureMonitorWorkspacesClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureMonitorWorkspacesClientListByResourceGroupResponse) (AzureMonitorWorkspacesClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AzureMonitorWorkspacesClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return AzureMonitorWorkspacesClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *AzureMonitorWorkspacesClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *AzureMonitorWorkspacesClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/accounts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-03-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *AzureMonitorWorkspacesClient) listByResourceGroupHandleResponse(resp *http.Response) (AzureMonitorWorkspacesClientListByResourceGroupResponse, error) {
	result := AzureMonitorWorkspacesClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureMonitorWorkspaceResourceListResult); err != nil {
		return AzureMonitorWorkspacesClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Lists all workspaces in the specified subscription
//
// Generated from API version 2021-06-03-preview
//   - options - AzureMonitorWorkspacesClientListBySubscriptionOptions contains the optional parameters for the AzureMonitorWorkspacesClient.NewListBySubscriptionPager
//     method.
func (client *AzureMonitorWorkspacesClient) NewListBySubscriptionPager(options *AzureMonitorWorkspacesClientListBySubscriptionOptions) *runtime.Pager[AzureMonitorWorkspacesClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureMonitorWorkspacesClientListBySubscriptionResponse]{
		More: func(page AzureMonitorWorkspacesClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureMonitorWorkspacesClientListBySubscriptionResponse) (AzureMonitorWorkspacesClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AzureMonitorWorkspacesClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return AzureMonitorWorkspacesClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *AzureMonitorWorkspacesClient) listBySubscriptionCreateRequest(ctx context.Context, options *AzureMonitorWorkspacesClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Monitor/accounts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-03-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *AzureMonitorWorkspacesClient) listBySubscriptionHandleResponse(resp *http.Response) (AzureMonitorWorkspacesClientListBySubscriptionResponse, error) {
	result := AzureMonitorWorkspacesClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureMonitorWorkspaceResourceListResult); err != nil {
		return AzureMonitorWorkspacesClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// Update - Updates part of a workspace
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-03-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureMonitorWorkspaceName - The name of the Azure Monitor workspace. The name is case insensitive
//   - options - AzureMonitorWorkspacesClientUpdateOptions contains the optional parameters for the AzureMonitorWorkspacesClient.Update
//     method.
func (client *AzureMonitorWorkspacesClient) Update(ctx context.Context, resourceGroupName string, azureMonitorWorkspaceName string, options *AzureMonitorWorkspacesClientUpdateOptions) (AzureMonitorWorkspacesClientUpdateResponse, error) {
	var err error
	const operationName = "AzureMonitorWorkspacesClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, azureMonitorWorkspaceName, options)
	if err != nil {
		return AzureMonitorWorkspacesClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureMonitorWorkspacesClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureMonitorWorkspacesClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *AzureMonitorWorkspacesClient) updateCreateRequest(ctx context.Context, resourceGroupName string, azureMonitorWorkspaceName string, options *AzureMonitorWorkspacesClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/accounts/{azureMonitorWorkspaceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureMonitorWorkspaceName == "" {
		return nil, errors.New("parameter azureMonitorWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureMonitorWorkspaceName}", url.PathEscape(azureMonitorWorkspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-03-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.AzureMonitorWorkspaceProperties != nil {
		if err := runtime.MarshalAsJSON(req, *options.AzureMonitorWorkspaceProperties); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *AzureMonitorWorkspacesClient) updateHandleResponse(resp *http.Response) (AzureMonitorWorkspacesClientUpdateResponse, error) {
	result := AzureMonitorWorkspacesClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureMonitorWorkspaceResource); err != nil {
		return AzureMonitorWorkspacesClientUpdateResponse{}, err
	}
	return result, nil
}
