// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1"
	v1 "k8s.io/api/core/v1"
)

// EmailConfigApplyConfiguration represents a declarative configuration of the EmailConfig type for use
// with apply.
type EmailConfigApplyConfiguration struct {
	SendResolved *bool                                         `json:"sendResolved,omitempty"`
	To           *string                                       `json:"to,omitempty"`
	From         *string                                       `json:"from,omitempty"`
	Hello        *string                                       `json:"hello,omitempty"`
	Smarthost    *string                                       `json:"smarthost,omitempty"`
	AuthUsername *string                                       `json:"authUsername,omitempty"`
	AuthPassword *v1.SecretKeySelector                         `json:"authPassword,omitempty"`
	AuthSecret   *v1.SecretKeySelector                         `json:"authSecret,omitempty"`
	AuthIdentity *string                                       `json:"authIdentity,omitempty"`
	Headers      []KeyValueApplyConfiguration                  `json:"headers,omitempty"`
	HTML         *string                                       `json:"html,omitempty"`
	Text         *string                                       `json:"text,omitempty"`
	RequireTLS   *bool                                         `json:"requireTLS,omitempty"`
	TLSConfig    *monitoringv1.SafeTLSConfigApplyConfiguration `json:"tlsConfig,omitempty"`
}

// EmailConfigApplyConfiguration constructs a declarative configuration of the EmailConfig type for use with
// apply.
func EmailConfig() *EmailConfigApplyConfiguration {
	return &EmailConfigApplyConfiguration{}
}

// WithSendResolved sets the SendResolved field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SendResolved field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithSendResolved(value bool) *EmailConfigApplyConfiguration {
	b.SendResolved = &value
	return b
}

// WithTo sets the To field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the To field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithTo(value string) *EmailConfigApplyConfiguration {
	b.To = &value
	return b
}

// WithFrom sets the From field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the From field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithFrom(value string) *EmailConfigApplyConfiguration {
	b.From = &value
	return b
}

// WithHello sets the Hello field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Hello field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithHello(value string) *EmailConfigApplyConfiguration {
	b.Hello = &value
	return b
}

// WithSmarthost sets the Smarthost field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Smarthost field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithSmarthost(value string) *EmailConfigApplyConfiguration {
	b.Smarthost = &value
	return b
}

// WithAuthUsername sets the AuthUsername field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AuthUsername field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithAuthUsername(value string) *EmailConfigApplyConfiguration {
	b.AuthUsername = &value
	return b
}

// WithAuthPassword sets the AuthPassword field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AuthPassword field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithAuthPassword(value v1.SecretKeySelector) *EmailConfigApplyConfiguration {
	b.AuthPassword = &value
	return b
}

// WithAuthSecret sets the AuthSecret field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AuthSecret field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithAuthSecret(value v1.SecretKeySelector) *EmailConfigApplyConfiguration {
	b.AuthSecret = &value
	return b
}

// WithAuthIdentity sets the AuthIdentity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AuthIdentity field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithAuthIdentity(value string) *EmailConfigApplyConfiguration {
	b.AuthIdentity = &value
	return b
}

// WithHeaders adds the given value to the Headers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Headers field.
func (b *EmailConfigApplyConfiguration) WithHeaders(values ...*KeyValueApplyConfiguration) *EmailConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithHeaders")
		}
		b.Headers = append(b.Headers, *values[i])
	}
	return b
}

// WithHTML sets the HTML field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HTML field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithHTML(value string) *EmailConfigApplyConfiguration {
	b.HTML = &value
	return b
}

// WithText sets the Text field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Text field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithText(value string) *EmailConfigApplyConfiguration {
	b.Text = &value
	return b
}

// WithRequireTLS sets the RequireTLS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RequireTLS field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithRequireTLS(value bool) *EmailConfigApplyConfiguration {
	b.RequireTLS = &value
	return b
}

// WithTLSConfig sets the TLSConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLSConfig field is set to the value of the last call.
func (b *EmailConfigApplyConfiguration) WithTLSConfig(value *monitoringv1.SafeTLSConfigApplyConfiguration) *EmailConfigApplyConfiguration {
	b.TLSConfig = value
	return b
}
