// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityAdvisory Advisory associated with the vulnerability.
type VulnerabilityAdvisory struct {
	// Vulnerability advisory ID.
	Id string `json:"id"`
	// Vulnerability advisory last modification date.
	LastModificationDate *string `json:"last_modification_date,omitempty"`
	// Vulnerability advisory publish date.
	PublishDate *string `json:"publish_date,omitempty"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewVulnerabilityAdvisory instantiates a new VulnerabilityAdvisory object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewVulnerabilityAdvisory(id string) *VulnerabilityAdvisory {
	this := VulnerabilityAdvisory{}
	this.Id = id
	return &this
}

// NewVulnerabilityAdvisoryWithDefaults instantiates a new VulnerabilityAdvisory object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewVulnerabilityAdvisoryWithDefaults() *VulnerabilityAdvisory {
	this := VulnerabilityAdvisory{}
	return &this
}

// GetId returns the Id field value.
func (o *VulnerabilityAdvisory) GetId() string {
	if o == nil {
		var ret string
		return ret
	}
	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAdvisory) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value.
func (o *VulnerabilityAdvisory) SetId(v string) {
	o.Id = v
}

// GetLastModificationDate returns the LastModificationDate field value if set, zero value otherwise.
func (o *VulnerabilityAdvisory) GetLastModificationDate() string {
	if o == nil || o.LastModificationDate == nil {
		var ret string
		return ret
	}
	return *o.LastModificationDate
}

// GetLastModificationDateOk returns a tuple with the LastModificationDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAdvisory) GetLastModificationDateOk() (*string, bool) {
	if o == nil || o.LastModificationDate == nil {
		return nil, false
	}
	return o.LastModificationDate, true
}

// HasLastModificationDate returns a boolean if a field has been set.
func (o *VulnerabilityAdvisory) HasLastModificationDate() bool {
	return o != nil && o.LastModificationDate != nil
}

// SetLastModificationDate gets a reference to the given string and assigns it to the LastModificationDate field.
func (o *VulnerabilityAdvisory) SetLastModificationDate(v string) {
	o.LastModificationDate = &v
}

// GetPublishDate returns the PublishDate field value if set, zero value otherwise.
func (o *VulnerabilityAdvisory) GetPublishDate() string {
	if o == nil || o.PublishDate == nil {
		var ret string
		return ret
	}
	return *o.PublishDate
}

// GetPublishDateOk returns a tuple with the PublishDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAdvisory) GetPublishDateOk() (*string, bool) {
	if o == nil || o.PublishDate == nil {
		return nil, false
	}
	return o.PublishDate, true
}

// HasPublishDate returns a boolean if a field has been set.
func (o *VulnerabilityAdvisory) HasPublishDate() bool {
	return o != nil && o.PublishDate != nil
}

// SetPublishDate gets a reference to the given string and assigns it to the PublishDate field.
func (o *VulnerabilityAdvisory) SetPublishDate(v string) {
	o.PublishDate = &v
}

// MarshalJSON serializes the struct using spec logic.
func (o VulnerabilityAdvisory) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	toSerialize["id"] = o.Id
	if o.LastModificationDate != nil {
		toSerialize["last_modification_date"] = o.LastModificationDate
	}
	if o.PublishDate != nil {
		toSerialize["publish_date"] = o.PublishDate
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *VulnerabilityAdvisory) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		Id                   *string `json:"id"`
		LastModificationDate *string `json:"last_modification_date,omitempty"`
		PublishDate          *string `json:"publish_date,omitempty"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	if all.Id == nil {
		return fmt.Errorf("required field id missing")
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"id", "last_modification_date", "publish_date"})
	} else {
		return err
	}
	o.Id = *all.Id
	o.LastModificationDate = all.LastModificationDate
	o.PublishDate = all.PublishDate

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	return nil
}
