// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func (m *NumberDataPoint) GetValue() any {
	if m != nil {
		return m.Value
	}
	return nil
}

type NumberDataPoint_AsDouble struct {
	AsDouble float64
}

func (m *NumberDataPoint) GetAsDouble() float64 {
	if v, ok := m.GetValue().(*NumberDataPoint_AsDouble); ok {
		return v.AsDouble
	}
	return float64(0)
}

type NumberDataPoint_AsInt struct {
	AsInt int64
}

func (m *NumberDataPoint) GetAsInt() int64 {
	if v, ok := m.GetValue().(*NumberDataPoint_AsInt); ok {
		return v.AsInt
	}
	return int64(0)
}

// NumberDataPoint is a single data point in a timeseries that describes the time-varying value of a number metric.
type NumberDataPoint struct {
	Attributes        []KeyValue
	StartTimeUnixNano uint64
	TimeUnixNano      uint64
	Value             any
	Exemplars         []Exemplar
	Flags             uint32
}

var (
	protoPoolNumberDataPoint = sync.Pool{
		New: func() any {
			return &NumberDataPoint{}
		},
	}

	ProtoPoolNumberDataPoint_AsDouble = sync.Pool{
		New: func() any {
			return &NumberDataPoint_AsDouble{}
		},
	}

	ProtoPoolNumberDataPoint_AsInt = sync.Pool{
		New: func() any {
			return &NumberDataPoint_AsInt{}
		},
	}
)

func NewNumberDataPoint() *NumberDataPoint {
	if !UseProtoPooling.IsEnabled() {
		return &NumberDataPoint{}
	}
	return protoPoolNumberDataPoint.Get().(*NumberDataPoint)
}

func DeleteNumberDataPoint(orig *NumberDataPoint, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}
	switch ov := orig.Value.(type) {
	case *NumberDataPoint_AsDouble:
		if UseProtoPooling.IsEnabled() {
			ov.AsDouble = float64(0)
			ProtoPoolNumberDataPoint_AsDouble.Put(ov)
		}
	case *NumberDataPoint_AsInt:
		if UseProtoPooling.IsEnabled() {
			ov.AsInt = int64(0)
			ProtoPoolNumberDataPoint_AsInt.Put(ov)
		}

	}
	for i := range orig.Exemplars {
		DeleteExemplar(&orig.Exemplars[i], false)
	}

	orig.Reset()
	if nullable {
		protoPoolNumberDataPoint.Put(orig)
	}
}

func CopyNumberDataPoint(dest, src *NumberDataPoint) *NumberDataPoint {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewNumberDataPoint()
	}
	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.StartTimeUnixNano = src.StartTimeUnixNano

	dest.TimeUnixNano = src.TimeUnixNano

	switch t := src.Value.(type) {
	case *NumberDataPoint_AsDouble:
		var ov *NumberDataPoint_AsDouble
		if !UseProtoPooling.IsEnabled() {
			ov = &NumberDataPoint_AsDouble{}
		} else {
			ov = ProtoPoolNumberDataPoint_AsDouble.Get().(*NumberDataPoint_AsDouble)
		}
		ov.AsDouble = t.AsDouble
		dest.Value = ov
	case *NumberDataPoint_AsInt:
		var ov *NumberDataPoint_AsInt
		if !UseProtoPooling.IsEnabled() {
			ov = &NumberDataPoint_AsInt{}
		} else {
			ov = ProtoPoolNumberDataPoint_AsInt.Get().(*NumberDataPoint_AsInt)
		}
		ov.AsInt = t.AsInt
		dest.Value = ov
	default:
		dest.Value = nil
	}
	dest.Exemplars = CopyExemplarSlice(dest.Exemplars, src.Exemplars)

	dest.Flags = src.Flags

	return dest
}

func CopyNumberDataPointSlice(dest, src []NumberDataPoint) []NumberDataPoint {
	var newDest []NumberDataPoint
	if cap(dest) < len(src) {
		newDest = make([]NumberDataPoint, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteNumberDataPoint(&dest[i], false)
		}
	}
	for i := range src {
		CopyNumberDataPoint(&newDest[i], &src[i])
	}
	return newDest
}

func CopyNumberDataPointPtrSlice(dest, src []*NumberDataPoint) []*NumberDataPoint {
	var newDest []*NumberDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*NumberDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewNumberDataPoint()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteNumberDataPoint(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewNumberDataPoint()
		}
	}
	for i := range src {
		CopyNumberDataPoint(newDest[i], src[i])
	}
	return newDest
}

func (orig *NumberDataPoint) Reset() {
	*orig = NumberDataPoint{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *NumberDataPoint) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	switch orig := orig.Value.(type) {
	case *NumberDataPoint_AsDouble:
		dest.WriteObjectField("asDouble")
		dest.WriteFloat64(orig.AsDouble)
	case *NumberDataPoint_AsInt:
		dest.WriteObjectField("asInt")
		dest.WriteInt64(orig.AsInt)
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		orig.Exemplars[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			orig.Exemplars[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *NumberDataPoint) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()

		case "asDouble", "as_double":
			{
				var ov *NumberDataPoint_AsDouble
				if !UseProtoPooling.IsEnabled() {
					ov = &NumberDataPoint_AsDouble{}
				} else {
					ov = ProtoPoolNumberDataPoint_AsDouble.Get().(*NumberDataPoint_AsDouble)
				}
				ov.AsDouble = iter.ReadFloat64()
				orig.Value = ov
			}

		case "asInt", "as_int":
			{
				var ov *NumberDataPoint_AsInt
				if !UseProtoPooling.IsEnabled() {
					ov = &NumberDataPoint_AsInt{}
				} else {
					ov = ProtoPoolNumberDataPoint_AsInt.Get().(*NumberDataPoint_AsInt)
				}
				ov.AsInt = iter.ReadInt64()
				orig.Value = ov
			}

		case "exemplars":
			for iter.ReadArray() {
				orig.Exemplars = append(orig.Exemplars, Exemplar{})
				orig.Exemplars[len(orig.Exemplars)-1].UnmarshalJSON(iter)
			}

		case "flags":
			orig.Flags = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func (orig *NumberDataPoint) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	switch orig := orig.Value.(type) {
	case nil:
		_ = orig
		break
	case *NumberDataPoint_AsDouble:
		n += 9
	case *NumberDataPoint_AsInt:
		n += 9
	}
	for i := range orig.Exemplars {
		l = orig.Exemplars[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Flags != 0 {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	return n
}

func (orig *NumberDataPoint) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	switch orig := orig.Value.(type) {
	case *NumberDataPoint_AsDouble:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.AsDouble))
		pos--
		buf[pos] = 0x21

	case *NumberDataPoint_AsInt:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.AsInt))
		pos--
		buf[pos] = 0x31

	}
	for i := len(orig.Exemplars) - 1; i >= 0; i-- {
		l = orig.Exemplars[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a
	}
	if orig.Flags != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x40
	}
	return len(buf) - pos
}

func (orig *NumberDataPoint) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsDouble", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *NumberDataPoint_AsDouble
			if !UseProtoPooling.IsEnabled() {
				ov = &NumberDataPoint_AsDouble{}
			} else {
				ov = ProtoPoolNumberDataPoint_AsDouble.Get().(*NumberDataPoint_AsDouble)
			}
			ov.AsDouble = math.Float64frombits(num)
			orig.Value = ov

		case 6:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsInt", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *NumberDataPoint_AsInt
			if !UseProtoPooling.IsEnabled() {
				ov = &NumberDataPoint_AsInt{}
			} else {
				ov = ProtoPoolNumberDataPoint_AsInt.Get().(*NumberDataPoint_AsInt)
			}
			ov.AsInt = int64(num)
			orig.Value = ov

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Exemplars = append(orig.Exemplars, Exemplar{})
			err = orig.Exemplars[len(orig.Exemplars)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 8:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestNumberDataPoint() *NumberDataPoint {
	orig := NewNumberDataPoint()
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.StartTimeUnixNano = uint64(13)
	orig.TimeUnixNano = uint64(13)
	orig.Value = &NumberDataPoint_AsDouble{AsDouble: float64(3.1415926)}
	orig.Exemplars = []Exemplar{{}, *GenTestExemplar()}
	orig.Flags = uint32(13)
	return orig
}

func GenTestNumberDataPointPtrSlice() []*NumberDataPoint {
	orig := make([]*NumberDataPoint, 5)
	orig[0] = NewNumberDataPoint()
	orig[1] = GenTestNumberDataPoint()
	orig[2] = NewNumberDataPoint()
	orig[3] = GenTestNumberDataPoint()
	orig[4] = NewNumberDataPoint()
	return orig
}

func GenTestNumberDataPointSlice() []NumberDataPoint {
	orig := make([]NumberDataPoint, 5)
	orig[1] = *GenTestNumberDataPoint()
	orig[3] = *GenTestNumberDataPoint()
	return orig
}
