/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge.colibri;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.OctoConfig;
import org.jitsi.jicofo.TranscriptionConfig;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.CascadeLink;
import org.jitsi.jicofo.bridge.CascadeNode;
import org.jitsi.jicofo.bridge.colibri.Colibri2Session;
import org.jitsi.jicofo.bridge.colibri.Colibri2SessionKt;
import org.jitsi.jicofo.bridge.colibri.ColibriV2SessionManager;
import org.jitsi.jicofo.bridge.colibri.ExtensionsKt;
import org.jitsi.jicofo.bridge.colibri.ParticipantInfo;
import org.jitsi.jicofo.codec.CodecUtil;
import org.jitsi.jicofo.codec.Config;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.TemplatedUrl;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Error;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;
import org.jitsi.xmpp.extensions.colibri2.InitialLastN;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ExtmapAllowMixedPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.muc.MUCRole;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001cB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ5\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u001e2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0002\b2J\u0017\u00103\u001a\u000704\u00a2\u0006\u0002\b52\b\b\u0002\u00106\u001a\u00020\bH\u0002J\r\u00107\u001a\u00020,H\u0000\u00a2\u0006\u0002\b8J\u001b\u00107\u001a\u00020,2\f\u00109\u001a\b\u0012\u0004\u0012\u00020/0.H\u0000\u00a2\u0006\u0002\b8J\u0015\u00107\u001a\u00020,2\u0006\u0010:\u001a\u00020/H\u0000\u00a2\u0006\u0002\b8J\r\u0010;\u001a\u00020,H\u0000\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b>J\u0016\u0010?\u001a\u00020,2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001e0.H\u0002J#\u0010A\u001a\u00020,2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\"\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bCJ\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\nH\u0002J\u0015\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020/H\u0000\u00a2\u0006\u0002\bJJ\u0018\u0010K\u001a\u00020,2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u001eH\u0002J\u001d\u0010O\u001a\u00020,2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\"\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bRJ\u0010\u0010S\u001a\u00020,2\b\u0010F\u001a\u0004\u0018\u00010\nJ\u0006\u0010T\u001a\u00020UJ\b\u0010V\u001a\u00020\u001eH\u0016J\u001b\u0010W\u001a\u00020,2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020/0XH\u0000\u00a2\u0006\u0002\bYJ3\u0010Z\u001a\u00020,2\u0006\u0010I\u001a\u00020/2\b\u0010P\u001a\u0004\u0018\u00010Q2\b\u0010[\u001a\u0004\u0018\u00010\\2\b\u0010]\u001a\u0004\u0018\u00010^H\u0000\u00a2\u0006\u0002\b_J%\u0010`\u001a\u00020,2\u0006\u0010a\u001a\u00020/2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\bH\u0000\u00a2\u0006\u0002\bbR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\u0004\u0018\u00010\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010 R$\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\b\u0012\u00060\u0002R\u00020\u00000%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0014R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lorg/jitsi/jicofo/bridge/colibri/Colibri2Session;", "Lorg/jitsi/jicofo/bridge/CascadeNode;", "Lorg/jitsi/jicofo/bridge/colibri/Colibri2Session$Relay;", "colibriSessionManager", "Lorg/jitsi/jicofo/bridge/colibri/ColibriV2SessionManager;", "bridge", "Lorg/jitsi/jicofo/bridge/Bridge;", "visitor", "", "transcriberUrl", "Lorg/jitsi/utils/TemplatedUrl;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/jicofo/bridge/colibri/ColibriV2SessionManager;Lorg/jitsi/jicofo/bridge/Bridge;ZLorg/jitsi/utils/TemplatedUrl;Lorg/jitsi/utils/logging2/Logger;)V", "getBridge", "()Lorg/jitsi/jicofo/bridge/Bridge;", "getColibriSessionManager", "()Lorg/jitsi/jicofo/bridge/colibri/ColibriV2SessionManager;", "created", "getCreated", "()Z", "setCreated", "(Z)V", "feedbackSources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "getFeedbackSources$jicofo_selector", "()Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "setFeedbackSources$jicofo_selector", "(Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;)V", "id", "", "getId", "()Ljava/lang/String;", "logger", "relayId", "getRelayId", "relays", "", "getRelays", "()Ljava/util/Map;", "getVisitor", "xmppConnection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "createRelay", "", "initialParticipants", "", "Lorg/jitsi/jicofo/bridge/colibri/ParticipantInfo;", "initiator", "meshId", "createRelay$jicofo_selector", "createRequest", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ$Builder;", "Lorg/jetbrains/annotations/NotNull;", "create", "expire", "expire$jicofo_selector", "participantsToExpire", "participantToExpire", "expireAllRelays", "expireAllRelays$jicofo_selector", "expireRelay", "expireRelay$jicofo_selector", "expireRelays", "relayIds", "expireRemoteParticipants", "participants", "expireRemoteParticipants$jicofo_selector", "resolveTranscriberUrl", "Ljava/net/URI;", "urlTemplate", "sendAllocationRequest", "Lorg/jivesoftware/smack/StanzaCollector;", "participant", "sendAllocationRequest$jicofo_selector", "sendRequest", "iq", "Lorg/jivesoftware/smack/packet/IQ;", "name", "setRelayTransport", "transport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "setRelayTransport$jicofo_selector", "setTranscriberUrl", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "toString", "updateForceMute", "", "updateForceMute$jicofo_selector", "updateParticipant", "sources", "Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "initialLastN", "Lorg/jitsi/xmpp/extensions/colibri2/InitialLastN;", "updateParticipant$jicofo_selector", "updateRemoteParticipant", "participantInfo", "updateRemoteParticipant$jicofo_selector", "Relay", "jicofo-selector"})
@SourceDebugExtension(value={"SMAP\nColibri2Session.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Colibri2Session.kt\norg/jitsi/jicofo/bridge/colibri/Colibri2Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,594:1\n1#2:595\n1855#3,2:596\n1855#3,2:598\n1855#3,2:600\n1549#3:602\n1620#3,3:603\n1855#3,2:606\n1855#3,2:608\n1855#3,2:610\n1549#3:612\n1620#3,3:613\n1549#3:616\n1620#3,3:617\n*S KotlinDebug\n*F\n+ 1 Colibri2Session.kt\norg/jitsi/jicofo/bridge/colibri/Colibri2Session\n*L\n114#1:596,2\n160#1:598,2\n189#1:600,2\n252#1:602\n252#1:603,3\n307#1:606,2\n316#1:608,2\n378#1:610,2\n191#1:612\n191#1:613,3\n281#1:616\n281#1:617,3\n*E\n"})
public final class Colibri2Session
implements CascadeNode<Colibri2Session, Relay> {
    @NotNull
    private final ColibriV2SessionManager colibriSessionManager;
    @NotNull
    private final Bridge bridge;
    private final boolean visitor;
    @Nullable
    private TemplatedUrl transcriberUrl;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AbstractXMPPConnection xmppConnection;
    @NotNull
    private final String id;
    @Nullable
    private final String relayId;
    private boolean created;
    @NotNull
    private ConferenceSourceMap feedbackSources;
    @NotNull
    private final Map<String, Relay> relays;

    /*
     * WARNING - void declaration
     */
    public Colibri2Session(@NotNull ColibriV2SessionManager colibriSessionManager, @NotNull Bridge bridge2, boolean visitor, @Nullable TemplatedUrl transcriberUrl, @NotNull Logger parentLogger) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)colibriSessionManager, (String)"colibriSessionManager");
        Intrinsics.checkNotNullParameter((Object)bridge2, (String)"bridge");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.colibriSessionManager = colibriSessionManager;
        this.bridge = bridge2;
        this.visitor = visitor;
        this.transcriberUrl = transcriberUrl;
        Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        Colibri2Session colibri2Session = this;
        boolean bl = false;
        Object object = this.bridge.getJid().getResourceOrNull();
        if (object != null && (object = object.toString()) != null) {
            void $this$logger_u24lambda_u241;
            Object it = object;
            boolean bl2 = false;
            $this$logger_u24lambda_u241.addContext("bridge", (String)it);
        }
        colibri2Session.logger = logger;
        this.xmppConnection = this.colibriSessionManager.getXmppConnection$jicofo_selector();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.relayId = this.bridge.getRelayId();
        this.feedbackSources = new ConferenceSourceMap(null, 1, null);
        this.relays = new LinkedHashMap();
    }

    @NotNull
    public final ColibriV2SessionManager getColibriSessionManager() {
        return this.colibriSessionManager;
    }

    @NotNull
    public final Bridge getBridge() {
        return this.bridge;
    }

    public final boolean getVisitor() {
        return this.visitor;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getRelayId() {
        return this.relayId;
    }

    public final boolean getCreated() {
        return this.created;
    }

    public final void setCreated(boolean bl) {
        this.created = bl;
    }

    @NotNull
    public final ConferenceSourceMap getFeedbackSources$jicofo_selector() {
        return this.feedbackSources;
    }

    public final void setFeedbackSources$jicofo_selector(@NotNull ConferenceSourceMap conferenceSourceMap) {
        Intrinsics.checkNotNullParameter((Object)conferenceSourceMap, (String)"<set-?>");
        this.feedbackSources = conferenceSourceMap;
    }

    @Override
    @NotNull
    public Map<String, Relay> getRelays() {
        return this.relays;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StanzaCollector sendAllocationRequest$jicofo_selector(@NotNull ParticipantInfo participant) {
        void $this$sendAllocationRequest_u24lambda_u243_u24lambda_u242;
        Transport.Builder builder;
        Colibri2Endpoint.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
        ConferenceModifyIQ.Builder request = this.createRequest(!this.created);
        Colibri2Endpoint.Builder $this$sendAllocationRequest_u24lambda_u243 = builder2 = ExtensionsKt.toEndpoint(participant, true, false);
        boolean bl = false;
        if (participant.getAudioMuted() || participant.getVideoMuted()) {
            $this$sendAllocationRequest_u24lambda_u243.setForceMute(participant.getAudioMuted(), participant.getVideoMuted());
        }
        if (participant.getVisitor()) {
            $this$sendAllocationRequest_u24lambda_u243.setMucRole(MUCRole.visitor);
        }
        Transport.Builder builder3 = builder = Transport.getBuilder();
        Colibri2Endpoint.Builder builder4 = $this$sendAllocationRequest_u24lambda_u243;
        boolean bl2 = false;
        $this$sendAllocationRequest_u24lambda_u243_u24lambda_u242.setIceControlling(true);
        if (participant.getUseSctp()) {
            $this$sendAllocationRequest_u24lambda_u243_u24lambda_u242.setSctp(new Sctp.Builder().build());
        }
        builder4.setTransport(builder.build());
        Colibri2Endpoint.Builder endpoint = builder2;
        Iterable $this$forEach$iv = participant.getMedias();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Media it = (Media)element$iv;
            boolean bl3 = false;
            endpoint.addMedia(it);
        }
        request.addEndpoint(endpoint.build());
        this.logger.trace(() -> Colibri2Session.sendAllocationRequest$lambda$5(participant, request));
        this.created = true;
        StanzaCollector stanzaCollector = this.xmppConnection.createStanzaCollectorAndSend((IQ)request.build());
        Intrinsics.checkNotNullExpressionValue((Object)stanzaCollector, (String)"createStanzaCollectorAndSend(...)");
        return stanzaCollector;
    }

    public final void updateParticipant$jicofo_selector(@NotNull ParticipantInfo participant, @Nullable IceUdpTransportPacketExtension transport, @Nullable EndpointSourceSet sources, @Nullable InitialLastN initialLastN) {
        Colibri2Endpoint.Builder builder;
        Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
        if (transport == null && sources == null && initialLastN == null) {
            this.logger.info((Object)"Nothing to update.");
            return;
        }
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Colibri2Endpoint.Builder $this$updateParticipant_u24lambda_u246 = builder = Colibri2Endpoint.getBuilder();
        boolean bl = false;
        $this$updateParticipant_u24lambda_u246.setId(participant.getId());
        $this$updateParticipant_u24lambda_u246.setStatsId(participant.getStatsId());
        Colibri2Endpoint.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
        Colibri2Endpoint.Builder endpoint = builder2;
        if (transport != null) {
            endpoint.setTransport(Transport.getBuilder().setIceUdpExtension(transport).build());
        }
        if (sources != null) {
            endpoint.setSources(ExtensionsKt.toColibriMediaSources(sources, participant.getId()));
        }
        InitialLastN initialLastN2 = initialLastN;
        if (initialLastN2 != null) {
            InitialLastN it = initialLastN2;
            boolean bl2 = false;
            endpoint.setInitialLastN(it);
        }
        request.addEndpoint(endpoint.build());
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
        this.sendRequest((IQ)conferenceModifyIQ, "updateParticipant");
    }

    /*
     * WARNING - void declaration
     */
    public final void updateForceMute$jicofo_selector(@NotNull Set<ParticipantInfo> participants) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = participants;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$updateForceMute_u24lambda_u249_u24lambda_u248;
            Colibri2Endpoint.Builder builder;
            ParticipantInfo participant = (ParticipantInfo)element$iv;
            boolean bl = false;
            Colibri2Endpoint.Builder builder2 = builder = Colibri2Endpoint.getBuilder();
            ConferenceModifyIQ.Builder builder3 = request;
            boolean bl2 = false;
            $this$updateForceMute_u24lambda_u249_u24lambda_u248.setId(participant.getId());
            $this$updateForceMute_u24lambda_u249_u24lambda_u248.setForceMute(participant.getAudioMuted(), participant.getVideoMuted());
            builder3.addEndpoint(builder.build());
        }
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
        this.sendRequest((IQ)conferenceModifyIQ, "updateForceMute");
    }

    public final void expire$jicofo_selector() {
        this.getRelays().clear();
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null).setExpire(true);
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
        this.sendRequest((IQ)conferenceModifyIQ, "expire");
    }

    public final void expire$jicofo_selector(@NotNull ParticipantInfo participantToExpire) {
        Intrinsics.checkNotNullParameter((Object)participantToExpire, (String)"participantToExpire");
        List<ParticipantInfo> list = Collections.singletonList(participantToExpire);
        Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
        this.expire$jicofo_selector(list);
    }

    public final void expire$jicofo_selector(@NotNull List<ParticipantInfo> participantsToExpire) {
        Intrinsics.checkNotNullParameter(participantsToExpire, (String)"participantsToExpire");
        if (participantsToExpire.isEmpty()) {
            this.logger.debug(Colibri2Session::expire$lambda$10);
            return;
        }
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = participantsToExpire;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticipantInfo it = (ParticipantInfo)element$iv;
            boolean bl = false;
            Colibri2SessionKt.access$addExpire(request, it.getId());
        }
        this.logger.debug(() -> Colibri2Session.expire$lambda$13(participantsToExpire));
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
        this.sendRequest((IQ)conferenceModifyIQ, "expire(participantsToExpire)");
    }

    private final ConferenceModifyIQ.Builder createRequest(boolean create) {
        ConferenceModifyIQ.Builder builder;
        ConferenceModifyIQ.Builder $this$createRequest_u24lambda_u2415 = builder = ConferenceModifyIQ.builder((XMPPConnection)((XMPPConnection)this.xmppConnection));
        boolean bl = false;
        $this$createRequest_u24lambda_u2415.to(this.bridge.getJid());
        $this$createRequest_u24lambda_u2415.setMeetingId(this.colibriSessionManager.getMeetingId$jicofo_selector());
        if (create) {
            $this$createRequest_u24lambda_u2415.setCreate(true);
            $this$createRequest_u24lambda_u2415.setConferenceName(this.colibriSessionManager.getConferenceName$jicofo_selector());
            $this$createRequest_u24lambda_u2415.setRtcstatsEnabled(this.colibriSessionManager.getRtcStatsEnabled$jicofo_selector());
            TemplatedUrl templatedUrl = this.transcriberUrl;
            if (templatedUrl != null) {
                TemplatedUrl it = templatedUrl;
                boolean bl2 = false;
                URI url = this.resolveTranscriberUrl(it);
                this.logger.info((Object)("Adding connect for transcriber, url=" + url));
                $this$createRequest_u24lambda_u2415.addConnect(Colibri2SessionKt.access$createConnect(url, TranscriptionConfig.config.getHttpHeaders()));
            }
        }
        ConferenceModifyIQ.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
        return builder2;
    }

    static /* synthetic */ ConferenceModifyIQ.Builder createRequest$default(Colibri2Session colibri2Session, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return colibri2Session.createRequest(bl);
    }

    private final URI resolveTranscriberUrl(TemplatedUrl urlTemplate2) {
        String string = this.bridge.getRegion();
        if (string == null) {
            string = "";
        }
        return urlTemplate2.resolve("REGION", string);
    }

    public final void setTranscriberUrl(@Nullable TemplatedUrl urlTemplate2) {
        if (!Intrinsics.areEqual((Object)this.transcriberUrl, (Object)urlTemplate2)) {
            this.transcriberUrl = urlTemplate2;
            ConferenceModifyIQ.Builder request = this.createRequest(false);
            if (urlTemplate2 != null) {
                URI url = this.resolveTranscriberUrl(urlTemplate2);
                this.logger.info((Object)("Adding connect, url=" + url));
                request.addConnect(Colibri2SessionKt.access$createConnect(url, TranscriptionConfig.config.getHttpHeaders()));
            } else {
                this.logger.info((Object)"Removing connects");
                request.setEmptyConnects();
            }
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
            this.sendRequest((IQ)conferenceModifyIQ, "setTranscriberUrl");
        } else {
            this.logger.info((Object)"No change in audio record URL.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void createRelay$jicofo_selector(@NotNull String relayId, @NotNull List<ParticipantInfo> initialParticipants, boolean initiator, @Nullable String meshId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)relayId, (String)"relayId");
        Intrinsics.checkNotNullParameter(initialParticipants, (String)"initialParticipants");
        Iterable iterable = initialParticipants;
        boolean bl = initiator;
        String string = relayId;
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        collection = (List)destination$iv$iv;
        logger.info((Object)("Creating relay " + string + " (initiator=" + bl + "), initial participants: " + (List)collection));
        if (this.getRelays().containsKey(relayId)) {
            throw new IllegalStateException("Relay " + relayId + " already exists (bridge=" + this.getRelayId());
        }
        Relay relay = new Relay(this, relayId, initiator, meshId);
        this.getRelays().put(relayId, relay);
        relay.start$jicofo_selector(initialParticipants);
    }

    public final void updateRemoteParticipant$jicofo_selector(@NotNull ParticipantInfo participantInfo, @NotNull String relayId, boolean create) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)participantInfo, (String)"participantInfo");
        Intrinsics.checkNotNullParameter((Object)relayId, (String)"relayId");
        this.logger.debug(() -> Colibri2Session.updateRemoteParticipant$lambda$17(participantInfo, relayId));
        Relay relay = this.getRelays().get(relayId);
        if (relay != null) {
            relay.updateParticipant(participantInfo, create);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist (bridge=" + this.getRelayId() + ")");
        }
    }

    public final void expireRemoteParticipants$jicofo_selector(@NotNull List<ParticipantInfo> participants, @NotNull String relayId) {
        Unit unit;
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)relayId, (String)"relayId");
        this.logger.debug(() -> Colibri2Session.expireRemoteParticipants$lambda$19(relayId, participants));
        Relay relay = this.getRelays().get(relayId);
        if (relay != null) {
            relay.expireParticipants(participants);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist (bridge=" + this.getRelayId() + ")");
        }
    }

    public final void setRelayTransport$jicofo_selector(@NotNull IceUdpTransportPacketExtension transport, @NotNull String relayId) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)relayId, (String)"relayId");
        this.logger.info((Object)("Setting relay transport for " + relayId));
        this.logger.debug(() -> Colibri2Session.setRelayTransport$lambda$20(relayId, transport));
        Relay relay = this.getRelays().get(relayId);
        if (relay != null) {
            relay.setTransport(transport);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist (bridge=" + this.getRelayId());
        }
    }

    public final void expireAllRelays$jicofo_selector() {
        this.expireRelays(CollectionsKt.toList((Iterable)this.getRelays().keySet()));
    }

    public final void expireRelay$jicofo_selector(@NotNull String relayId) {
        Intrinsics.checkNotNullParameter((Object)relayId, (String)"relayId");
        this.expireRelays(CollectionsKt.listOf((Object)relayId));
    }

    /*
     * WARNING - void declaration
     */
    private final void expireRelays(List<String> relayIds) {
        String it;
        if (relayIds.isEmpty()) {
            this.logger.debug((Object)"No relays to expire.");
            return;
        }
        this.logger.info((Object)("Expiring relays: " + relayIds));
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = relayIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$expireRelays_u24lambda_u2422_u24lambda_u2421;
            Colibri2Relay.Builder builder;
            it = (String)element$iv;
            boolean bl = false;
            Colibri2Relay.Builder builder2 = builder = Colibri2Relay.getBuilder();
            ConferenceModifyIQ.Builder builder3 = request;
            boolean bl2 = false;
            $this$expireRelays_u24lambda_u2422_u24lambda_u2421.setId(it);
            $this$expireRelays_u24lambda_u2422_u24lambda_u2421.setExpire(true);
            builder3.addRelay(builder.build());
        }
        $this$forEach$iv = relayIds;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.getRelays().remove(it);
        }
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
        this.sendRequest((IQ)conferenceModifyIQ, "expireRelays");
    }

    private final void sendRequest(IQ iq, String name) {
        this.logger.debug(() -> Colibri2Session.sendRequest$lambda$24(name, iq));
        ExtensionsKt.sendIqAndHandleResponseAsync(this.xmppConnection, iq, (Function1<? super IQ, Unit>)((Function1)new Function1<IQ, Unit>(this, name, iq){
            final /* synthetic */ Colibri2Session this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ IQ $iq;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$iq = $iq;
                super(1);
            }

            public final void invoke(@Nullable IQ response) {
                if (response == null) {
                    Colibri2Session.access$getLogger$p(this.this$0).info((Object)(this.$name + " request timed out. Ignoring."));
                    return;
                }
                StanzaError stanzaError = response.getError();
                if (stanzaError != null) {
                    boolean reInvite;
                    StanzaError stanzaError2 = stanzaError;
                    Colibri2Session colibri2Session = this.this$0;
                    IQ iQ = this.$iq;
                    String string = this.$name;
                    StanzaError error = stanzaError2;
                    boolean bl = false;
                    Colibri2Error colibri2Error = (Colibri2Error)error.getExtension("error", "jitsi:colibri2");
                    Colibri2Error.Reason reason = colibri2Error != null ? colibri2Error.getReason() : null;
                    Colibri2Endpoint colibri2Endpoint = (Colibri2Endpoint)error.getExtension("endpoint", "jitsi:colibri2");
                    String endpointId = colibri2Endpoint != null ? colibri2Endpoint.getId() : null;
                    boolean bl2 = reInvite = reason == Colibri2Error.Reason.UNKNOWN_ENDPOINT && endpointId != null;
                    if (reInvite) {
                        Colibri2Session.access$getLogger$p(colibri2Session).warn((Object)("Endpoint [" + endpointId + "] is not found, session failed: " + error.toXML() + ", request was: " + iQ.toXML()));
                        ColibriV2SessionManager colibriV2SessionManager = colibri2Session.getColibriSessionManager();
                        String string2 = endpointId;
                        Intrinsics.checkNotNull((Object)string2);
                        colibriV2SessionManager.endpointFailed$jicofo_selector(string2);
                    } else {
                        Colibri2Session.access$getLogger$p(colibri2Session).error((Object)("Received error response for " + string + ", session failed: " + error.toXML()));
                        colibri2Session.getColibriSessionManager().sessionFailed$jicofo_selector(colibri2Session);
                    }
                    return;
                }
                if (!(response instanceof ConferenceModifiedIQ)) {
                    Colibri2Session.access$getLogger$p(this.this$0).error((Object)("Received response with unexpected type " + response.getClass().getName()));
                    this.this$0.getColibriSessionManager().sessionFailed$jicofo_selector(this.this$0);
                } else {
                    Colibri2Session.access$getLogger$p(this.this$0).debug(() -> sendRequest.2.invoke$lambda$1(this.$name, response));
                }
            }

            private static final String invoke$lambda$1(String $name, IQ $response) {
                Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
                return "Received " + $name + " response: " + ((ConferenceModifiedIQ)$response).toXML();
            }
        }));
    }

    @NotNull
    public String toString() {
        return "Colibri2Session[bridge=" + this.bridge.getJid().getResourceOrNull() + ", id=" + this.id + "]";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OrderedJsonObject toJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject orderedJsonObject2;
        OrderedJsonObject $this$toJson_u24lambda_u2427 = orderedJsonObject2 = new OrderedJsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u2427.put((Object)"bridge", (Object)this.bridge.getDebugState());
        $this$toJson_u24lambda_u2427.put((Object)"id", (Object)this.id);
        $this$toJson_u24lambda_u2427.put((Object)"feedback_sources", (Object)this.feedbackSources.toJson());
        $this$toJson_u24lambda_u2427.put((Object)"created", (Object)this.created);
        OrderedJsonObject orderedJsonObject3 = orderedJsonObject = new OrderedJsonObject();
        String string = "relays";
        OrderedJsonObject orderedJsonObject4 = $this$toJson_u24lambda_u2427;
        boolean bl2 = false;
        Iterable $this$forEach$iv = this.getRelays().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$toJson_u24lambda_u2427_u24lambda_u2426;
            Relay it = (Relay)element$iv;
            boolean bl3 = false;
            $this$toJson_u24lambda_u2427_u24lambda_u2426.put((Object)it.getRelayId(), (Object)it.toJson());
        }
        Unit unit = Unit.INSTANCE;
        orderedJsonObject4.put((Object)string, (Object)orderedJsonObject);
        return orderedJsonObject2;
    }

    private static final String sendAllocationRequest$lambda$5(ParticipantInfo $participant, ConferenceModifyIQ.Builder $request) {
        Intrinsics.checkNotNullParameter((Object)$participant, (String)"$participant");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        return "Sending allocation request for " + $participant.getId() + ": " + $request.build().toXML();
    }

    private static final String expire$lambda$10() {
        return "No participants to expire.";
    }

    /*
     * WARNING - void declaration
     */
    private static final String expire$lambda$13(List $participantsToExpire) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$participantsToExpire, (String)"$participantsToExpire");
        Iterable $this$map$iv = $participantsToExpire;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return "Expiring endpoint: " + (List)destination$iv$iv;
    }

    private static final String updateRemoteParticipant$lambda$17(ParticipantInfo $participantInfo, String $relayId) {
        Intrinsics.checkNotNullParameter((Object)$participantInfo, (String)"$participantInfo");
        Intrinsics.checkNotNullParameter((Object)$relayId, (String)"$relayId");
        return "Updating remote participant " + $participantInfo.getId() + " on " + $relayId;
    }

    /*
     * WARNING - void declaration
     */
    private static final String expireRemoteParticipants$lambda$19(String $relayId, List $participants) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$relayId, (String)"$relayId");
        Intrinsics.checkNotNullParameter((Object)$participants, (String)"$participants");
        Iterable iterable = $participants;
        String string = $relayId;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return "Expiring remote participants on " + string + ": " + (List)destination$iv$iv;
    }

    private static final String setRelayTransport$lambda$20(String $relayId, IceUdpTransportPacketExtension $transport) {
        Intrinsics.checkNotNullParameter((Object)$relayId, (String)"$relayId");
        Intrinsics.checkNotNullParameter((Object)$transport, (String)"$transport");
        return "Setting relay transport for " + $relayId + ": " + $transport.toXML();
    }

    private static final String sendRequest$lambda$24(String $name, IQ $iq) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$iq, (String)"$iq");
        return "Sending " + $name + " request: " + $iq.toXML();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u001b\u0010\u001d\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0000\u00a2\u0006\u0002\b\u001fJ\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jitsi/jicofo/bridge/colibri/Colibri2Session$Relay;", "Lorg/jitsi/jicofo/bridge/CascadeLink;", "relayId", "", "initiator", "", "meshId", "(Lorg/jitsi/jicofo/bridge/colibri/Colibri2Session;Ljava/lang/String;ZLjava/lang/String;)V", "bridgeChannelActive", "dtlsSetup", "iceControlling", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getMeshId", "()Ljava/lang/String;", "getRelayId", "sctpBridgeChannel", "useUniquePort", "buildCreateRelayRequest", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "participants", "", "Lorg/jitsi/jicofo/bridge/colibri/ParticipantInfo;", "expireParticipants", "", "", "setTransport", "transport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "start", "initialParticipants", "start$jicofo_selector", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "updateParticipant", "participant", "create", "jicofo-selector"})
    @SourceDebugExtension(value={"SMAP\nColibri2Session.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Colibri2Session.kt\norg/jitsi/jicofo/bridge/colibri/Colibri2Session$Relay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,594:1\n1#2:595\n1855#3,2:596\n1855#3,2:598\n1726#3,3:600\n1855#3,2:603\n1855#3,2:605\n1855#3,2:607\n1855#3,2:609\n1855#3,2:611\n766#3:613\n857#3,2:614\n1855#3,2:616\n*S KotlinDebug\n*F\n+ 1 Colibri2Session.kt\norg/jitsi/jicofo/bridge/colibri/Colibri2Session$Relay\n*L\n449#1:596,2\n462#1:598,2\n503#1:600,3\n510#1:603,2\n534#1:605,2\n535#1:607,2\n544#1:609,2\n545#1:611,2\n553#1:613\n553#1:614,2\n553#1:616,2\n*E\n"})
    public final class Relay
    implements CascadeLink {
        @NotNull
        private final String relayId;
        @Nullable
        private final String meshId;
        private final boolean useUniquePort;
        private final boolean iceControlling;
        @NotNull
        private final String dtlsSetup;
        private final boolean bridgeChannelActive;
        private final boolean sctpBridgeChannel;
        @NotNull
        private final Logger logger;
        final /* synthetic */ Colibri2Session this$0;

        /*
         * WARNING - void declaration
         */
        public Relay(@NotNull Colibri2Session this$0, String relayId, @Nullable boolean initiator, String meshId) {
            void $this$logger_u24lambda_u240;
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)relayId, (String)"relayId");
            this.this$0 = this$0;
            this.relayId = relayId;
            this.meshId = meshId;
            this.useUniquePort = initiator;
            this.iceControlling = initiator;
            this.dtlsSetup = initiator ? "active" : "passive";
            this.bridgeChannelActive = initiator;
            this.sctpBridgeChannel = OctoConfig.config.getSctpDatachannels();
            Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)this.this$0.logger, null, (int)2, null);
            Relay relay = this;
            boolean bl = false;
            $this$logger_u24lambda_u240.addContext("relay", this.getRelayId());
            relay.logger = logger;
        }

        public /* synthetic */ Relay(Colibri2Session colibri2Session, String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(colibri2Session, string, bl, string2);
        }

        @Override
        @NotNull
        public String getRelayId() {
            return this.relayId;
        }

        @Override
        @Nullable
        public String getMeshId() {
            return this.meshId;
        }

        public final void start$jicofo_selector(@NotNull List<ParticipantInfo> initialParticipants) {
            Intrinsics.checkNotNullParameter(initialParticipants, (String)"initialParticipants");
            ConferenceModifyIQ request = this.buildCreateRelayRequest((Collection<ParticipantInfo>)initialParticipants);
            this.logger.trace(() -> Relay.start$lambda$1(request));
            ExtensionsKt.sendIqAndHandleResponseAsync(this.this$0.xmppConnection, (IQ)request, (Function1<? super IQ, Unit>)((Function1)new Function1<IQ, Unit>(this, this.this$0){
                final /* synthetic */ Relay this$0;
                final /* synthetic */ Colibri2Session this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@Nullable IQ response) {
                    Relay.access$getLogger$p(this.this$0).trace(() -> start.2.invoke$lambda$0(response));
                    if (!(response instanceof ConferenceModifiedIQ)) {
                        Logger logger = Relay.access$getLogger$p(this.this$0);
                        IQ iQ = response;
                        CharSequence charSequence = iQ != null ? iQ.toXML() : null;
                        if (charSequence == null) {
                            charSequence = "timeout";
                        }
                        logger.error((Object)("Received error: " + charSequence));
                        this.this$1.getColibriSessionManager().sessionFailed$jicofo_selector(this.this$1);
                        return;
                    }
                    List list = ((ConferenceModifiedIQ)response).getRelays();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRelays(...)");
                    Colibri2Relay colibri2Relay = (Colibri2Relay)CollectionsKt.firstOrNull((List)list);
                    if (colibri2Relay == null || (colibri2Relay = colibri2Relay.getTransport()) == null) {
                        Relay relay = this.this$0;
                        Colibri2Session colibri2Session = this.this$1;
                        Relay $this$invoke_u24lambda_u241 = relay;
                        boolean bl = false;
                        Relay.access$getLogger$p($this$invoke_u24lambda_u241).error((Object)("No transport in response: " + ((ConferenceModifiedIQ)response).toXML()));
                        colibri2Session.getColibriSessionManager().sessionFailed$jicofo_selector(colibri2Session);
                        return;
                    }
                    Colibri2Relay transport = colibri2Relay;
                    IceUdpTransportPacketExtension iceUdpTransport = transport.getIceUdpTransport();
                    if (iceUdpTransport == null) {
                        Relay.access$getLogger$p(this.this$0).error((Object)"Response has no iceUdpTransport");
                        this.this$1.getColibriSessionManager().sessionFailed$jicofo_selector(this.this$1);
                        return;
                    }
                    this.this$1.getColibriSessionManager().setRelayTransport$jicofo_selector(this.this$1, iceUdpTransport, this.this$0.getRelayId());
                }

                private static final String invoke$lambda$0(IQ $response) {
                    IQ iQ = $response;
                    return "Received response: " + (iQ != null ? iQ.toXML() : null);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        public final void setTransport(@NotNull IceUdpTransportPacketExtension transport) {
            void $this$setTransport_u24lambda_u245;
            DtlsFingerprintPacketExtension it;
            Object element$iv2;
            Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
            List list = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildExtensionsOfType(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (DtlsFingerprintPacketExtension)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSetup(), (Object)"actpass")) {
                    this.logger.error((Object)("Response has an unexpected dtls setup field: " + it.getSetup()));
                    return;
                }
                this.logger.info((Object)("Setting setup=" + this.dtlsSetup + " for " + this.getRelayId()));
                it.setSetup(this.dtlsSetup);
            }
            if (this.sctpBridgeChannel || !this.bridgeChannelActive) {
                List list2 = transport.getChildExtensionsOfType(WebSocketPacketExtension.class);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildExtensionsOfType(...)");
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    it = (WebSocketPacketExtension)element$iv2;
                    boolean bl = false;
                    transport.removeChildExtension((ExtensionElement)it);
                }
            }
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this.this$0, false, 1, null);
            Object $this$setTransport_u24lambda_u244 = element$iv2 = Colibri2Relay.getBuilder();
            boolean bl = false;
            $this$setTransport_u24lambda_u244.setId(this.getRelayId());
            $this$setTransport_u24lambda_u244.setCreate(false);
            Object object = element$iv2;
            Intrinsics.checkNotNullExpressionValue(object, (String)"apply(...)");
            Object relay = object;
            Transport.Builder builder = Transport.getBuilder();
            element$iv2 = builder;
            Object object2 = relay;
            boolean bl2 = false;
            $this$setTransport_u24lambda_u245.setIceUdpExtension(transport);
            object2.setTransport(builder.build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
            this.this$0.sendRequest((IQ)conferenceModifyIQ, "Relay.setTransport");
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            block0: {
                OrderedJsonObject $this$toJson_u24lambda_u247 = orderedJsonObject = new OrderedJsonObject();
                boolean bl = false;
                $this$toJson_u24lambda_u247.put((Object)"id", (Object)this.getRelayId());
                $this$toJson_u24lambda_u247.put((Object)"use_unique_port", (Object)this.useUniquePort);
                $this$toJson_u24lambda_u247.put((Object)"ice_controlling", (Object)this.iceControlling);
                $this$toJson_u24lambda_u247.put((Object)"dtls_setup", (Object)this.dtlsSetup);
                $this$toJson_u24lambda_u247.put((Object)"bridge_channel_active", (Object)this.bridgeChannelActive);
                $this$toJson_u24lambda_u247.put((Object)"sctp_bridge_channel", (Object)this.sctpBridgeChannel);
                String string = this.getMeshId();
                if (string == null) break block0;
                String it = string;
                boolean bl2 = false;
                $this$toJson_u24lambda_u247.put((Object)"mesh_id", (Object)it);
            }
            return orderedJsonObject;
        }

        public final void updateParticipant(@NotNull ParticipantInfo participant, boolean create) {
            Colibri2Relay.Builder builder;
            Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this.this$0, false, 1, null);
            Colibri2Relay.Builder $this$updateParticipant_u24lambda_u248 = builder = Colibri2Relay.getBuilder();
            boolean bl = false;
            $this$updateParticipant_u24lambda_u248.setId(this.getRelayId());
            Colibri2Relay.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
            Colibri2Relay.Builder relay = builder2;
            Endpoints.Builder builder3 = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"getBuilder(...)");
            Endpoints.Builder endpoints = builder3;
            endpoints.addEndpoint(ExtensionsKt.toEndpoint(participant, create, false).build());
            relay.setEndpoints(endpoints.build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
            this.this$0.sendRequest((IQ)conferenceModifyIQ, "Relay.updateParticipant");
        }

        public final void expireParticipants(@NotNull List<ParticipantInfo> participants) {
            Object element$iv2;
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter(participants, (String)"participants");
                Iterable $this$all$iv = participants;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        ParticipantInfo it = (ParticipantInfo)element$iv2;
                        boolean bl2 = false;
                        if (it.getVisitor()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this.this$0, false, 1, null);
            Object $this$expireParticipants_u24lambda_u2410 = element$iv2 = Colibri2Relay.getBuilder();
            boolean bl3 = false;
            $this$expireParticipants_u24lambda_u2410.setId(this.getRelayId());
            Object object = element$iv2;
            Intrinsics.checkNotNullExpressionValue(object, (String)"apply(...)");
            Object relay = object;
            Endpoints.Builder builder = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"getBuilder(...)");
            Endpoints.Builder endpoints = builder;
            Iterable $this$forEach$iv = participants;
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                ParticipantInfo it = (ParticipantInfo)element$iv3;
                boolean bl4 = false;
                if (it.getVisitor()) continue;
                endpoints.addEndpoint(ExtensionsKt.toEndpoint(it, false, true).build());
            }
            relay.setEndpoints(endpoints.build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
            this.this$0.sendRequest((IQ)conferenceModifyIQ, "Relay.expireParticipants");
        }

        /*
         * WARNING - void declaration
         */
        private final ConferenceModifyIQ buildCreateRelayRequest(Collection<ParticipantInfo> participants) {
            void $this$buildCreateRelayRequest_u24lambda_u2422;
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            void $this$buildCreateRelayRequest_u24lambda_u2419;
            PayloadTypePacketExtension it;
            Object element$iv2;
            Media.Builder $this$buildCreateRelayRequest_u24lambda_u2416;
            Colibri2Relay.Builder builder;
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this.this$0, false, 1, null);
            Colibri2Relay.Builder $this$buildCreateRelayRequest_u24lambda_u2413 = builder = Colibri2Relay.getBuilder();
            boolean bl = false;
            $this$buildCreateRelayRequest_u24lambda_u2413.setId(this.getRelayId());
            String string = this.getMeshId();
            if (string != null) {
                String it2 = string;
                boolean bl2 = false;
                $this$buildCreateRelayRequest_u24lambda_u2413.setMeshId(it2);
            }
            $this$buildCreateRelayRequest_u24lambda_u2413.setCreate(true);
            Colibri2Relay.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
            Colibri2Relay.Builder relay = builder2;
            Media.Builder builder3 = Media.getBuilder();
            builder = builder3;
            Colibri2Relay.Builder builder4 = relay;
            boolean bl3 = false;
            $this$buildCreateRelayRequest_u24lambda_u2416.setType(MediaType.AUDIO);
            Iterable $this$forEach$iv2 = CodecUtil.Companion.createAudioPayloadTypeExtensions$default((CodecUtil.Companion)CodecUtil.Companion, null, (int)1, null);
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (PayloadTypePacketExtension)element$iv2;
                boolean bl4 = false;
                $this$buildCreateRelayRequest_u24lambda_u2416.addPayloadType(it);
            }
            $this$forEach$iv2 = CodecUtil.Companion.createAudioRtpHdrExtExtensions$default((CodecUtil.Companion)CodecUtil.Companion, null, (int)1, null);
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (RTPHdrExtPacketExtension)element$iv2;
                boolean bl5 = false;
                $this$buildCreateRelayRequest_u24lambda_u2416.addRtpHdrExt((RTPHdrExtPacketExtension)it);
            }
            if (Config.config.getExtmapAllowMixed()) {
                $this$buildCreateRelayRequest_u24lambda_u2416.setExtmapAllowMixed(new ExtmapAllowMixedPacketExtension());
            }
            builder4.addMedia(builder3.build());
            $this$buildCreateRelayRequest_u24lambda_u2416 = builder3 = Media.getBuilder();
            builder4 = relay;
            boolean bl6 = false;
            $this$buildCreateRelayRequest_u24lambda_u2419.setType(MediaType.VIDEO);
            $this$forEach$iv2 = CodecUtil.Companion.createVideoPayloadTypeExtensions$default((CodecUtil.Companion)CodecUtil.Companion, null, (int)1, null);
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (PayloadTypePacketExtension)element$iv2;
                boolean bl7 = false;
                $this$buildCreateRelayRequest_u24lambda_u2419.addPayloadType(it);
            }
            $this$forEach$iv2 = CodecUtil.Companion.createVideoRtpHdrExtExtensions$default((CodecUtil.Companion)CodecUtil.Companion, null, (int)1, null);
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (RTPHdrExtPacketExtension)element$iv2;
                boolean bl8 = false;
                $this$buildCreateRelayRequest_u24lambda_u2419.addRtpHdrExt((RTPHdrExtPacketExtension)it);
            }
            if (Config.config.getExtmapAllowMixed()) {
                $this$buildCreateRelayRequest_u24lambda_u2419.setExtmapAllowMixed(new ExtmapAllowMixedPacketExtension());
            }
            builder4.addMedia(builder3.build());
            Endpoints.Builder builder5 = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"getBuilder(...)");
            Endpoints.Builder endpoints = builder5;
            Iterable $this$filter$iv = participants;
            boolean $i$f$filter = false;
            $this$forEach$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            element$iv2 = $this$filterTo$iv$iv.iterator();
            while (element$iv2.hasNext()) {
                Object element$iv$iv = element$iv2.next();
                ParticipantInfo it3 = (ParticipantInfo)element$iv$iv;
                boolean bl9 = false;
                if (!(!it3.getVisitor())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach22 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                ParticipantInfo it4 = (ParticipantInfo)element$iv3;
                boolean bl10 = false;
                endpoints.addEndpoint(ExtensionsKt.toEndpoint(it4, true, false).build());
            }
            relay.setEndpoints(endpoints.build());
            Colibri2Relay.Builder $i$f$forEach22 = builder = Transport.getBuilder();
            builder4 = relay;
            boolean bl11 = false;
            $this$buildCreateRelayRequest_u24lambda_u2422.setUseUniquePort(this.useUniquePort);
            $this$buildCreateRelayRequest_u24lambda_u2422.setIceControlling(this.iceControlling);
            if (this.sctpBridgeChannel) {
                Sctp.Builder sctp = new Sctp.Builder();
                sctp.setRole(this.bridgeChannelActive ? Sctp.Role.CLIENT : Sctp.Role.SERVER);
                $this$buildCreateRelayRequest_u24lambda_u2422.setSctp(sctp.build());
            }
            builder4.setTransport(builder.build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue((Object)conferenceModifyIQ, (String)"build(...)");
            return conferenceModifyIQ;
        }

        private static final String start$lambda$1(ConferenceModifyIQ $request) {
            Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
            return "Sending create relay: " + $request.toXML();
        }

        public static final /* synthetic */ Logger access$getLogger$p(Relay $this) {
            return $this.logger;
        }
    }
}

