/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.swing.logging;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.seamless.swing.logging.LogMessage;

public abstract class LogTableCellRenderer
extends DefaultTableCellRenderer {
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS");

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        LogMessage message = (LogMessage)value;
        switch (column) {
            case 0: {
                if (message.getLevel().equals(Level.SEVERE) || message.getLevel().equals(Level.WARNING)) {
                    return new JLabel(this.getWarnErrorIcon());
                }
                if (message.getLevel().equals(Level.FINE)) {
                    return new JLabel(this.getDebugIcon());
                }
                if (message.getLevel().equals(Level.FINER) || message.getLevel().equals(Level.FINEST)) {
                    return new JLabel(this.getTraceIcon());
                }
                return new JLabel(this.getInfoIcon());
            }
            case 1: {
                Date date = new Date(message.getCreatedOn());
                return super.getTableCellRendererComponent(table, this.dateFormat.format(date), isSelected, hasFocus, row, column);
            }
            case 2: {
                return super.getTableCellRendererComponent(table, message.getThread(), isSelected, hasFocus, row, column);
            }
            case 3: {
                return super.getTableCellRendererComponent(table, message.getSource(), isSelected, hasFocus, row, column);
            }
        }
        return super.getTableCellRendererComponent(table, message.getMessage().replaceAll("\n", "<NL>").replaceAll("\r", "<CR>"), isSelected, hasFocus, row, column);
    }

    protected abstract ImageIcon getWarnErrorIcon();

    protected abstract ImageIcon getInfoIcon();

    protected abstract ImageIcon getDebugIcon();

    protected abstract ImageIcon getTraceIcon();
}

