/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDFEntryIterator
implements Iterator<UDFFileEntry> {
    private static final Log log = LogFactory.getLog(UDFEntryIterator.class);
    private final UDFFileSystem fs;
    private final List<UDFFileEntry> queue;

    public UDFEntryIterator(UDFFileSystem uDFFileSystem, UDFFileEntry uDFFileEntry) {
        this.fs = uDFFileSystem;
        this.queue = new LinkedList<UDFFileEntry>();
        if (uDFFileEntry != null) {
            this.queue.add(uDFFileEntry);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public UDFFileEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        UDFFileEntry uDFFileEntry = this.queue.remove(0);
        if (uDFFileEntry.isDirectory()) {
            try {
                uDFFileEntry.loadFiles();
                for (UDFFileEntry uDFFileEntry2 : uDFFileEntry.getFiles()) {
                    log.debug((Object)("found FileEntry: " + uDFFileEntry2.getPath()));
                    this.queue.add(uDFFileEntry2);
                }
            }
            catch (Exception exception) {
                log.error((Object)("Could not load files!" + exception));
                throw new RuntimeException(exception);
            }
        }
        return uDFFileEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

