/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.CharSpec;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMap;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapMetadata;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapSparable;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapType1;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapType2;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.util.ArrayList;
import java.util.List;

public class LogicalVolumeDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSequenceNumber;
    public CharSpec descriptorCharacterSet;
    public DString logicalVolumeIdentifier;
    public Long logicalBlockSize;
    public RegId domainIdentifier;
    public LongAD logicalVolumeContentsUse;
    public Long mapTableLength;
    public Long numberofPartitionMaps;
    public RegId implementationIdentifier;
    public byte[] implementationUse;
    public ExtentAD integritySequenceExtent;
    public List<PartitionMap> partitionMaps;
    public final int MINIMUM_LENGTH = 512;

    public LogicalVolumeDescriptor() {
    }

    public LogicalVolumeDescriptor(byte[] byArray) throws InvalidDescriptor {
        super(byArray);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 6;
    }

    @Override
    public void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 512) {
            throw new InvalidDescriptor("Logical volume descriptor too short");
        }
        this.deserializeTag(byArray);
        this.volumeDescriptorSequenceNumber = this.getUInt32(byArray);
        this.descriptorCharacterSet = new CharSpec(this.getBytes(byArray, 64));
        this.logicalVolumeIdentifier = new DString(this.getBytes(byArray, 128));
        this.logicalBlockSize = this.getUInt32(byArray);
        this.domainIdentifier = new RegId(this.getBytes(byArray, 32));
        this.logicalVolumeContentsUse = new LongAD(this.getBytes(byArray, 16));
        this.mapTableLength = this.getUInt32(byArray);
        this.numberofPartitionMaps = this.getUInt32(byArray);
        this.implementationIdentifier = new RegId(this.getBytes(byArray, 32));
        this.implementationUse = this.getBytes(byArray, 128);
        this.integritySequenceExtent = new ExtentAD(this.getBytes(byArray, 8));
        this.partitionMaps = new ArrayList<PartitionMap>();
        int n = 0;
        while ((long)n < this.numberofPartitionMaps) {
            Object object;
            byte by = byArray[this.currentPos];
            if (by == 1) {
                object = new PartitionMapType1(this.getBytes(byArray, 6));
                this.partitionMaps.add((PartitionMap)object);
            } else if (by == 2) {
                object = this.getBytes(byArray, 64);
                PartitionMapType2 partitionMapType2 = new PartitionMapType2((byte[])object);
                if (partitionMapType2.partitionTypeIdentifier.getId().equals("*UDF Sparable Partition")) {
                    this.partitionMaps.add(new PartitionMapSparable((byte[])object));
                } else if (partitionMapType2.partitionTypeIdentifier.getId().equals("*UDF Metadata Partition")) {
                    this.partitionMaps.add(new PartitionMapMetadata((byte[])object));
                }
            } else {
                new InvalidDescriptor("Unknown partition map type " + by);
            }
            ++n;
        }
    }
}

