/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LBAddr;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidICBTag;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLBAddr;
import java.nio.charset.StandardCharsets;

public class ICBTag {
    public Long priorEntryNum;
    public Integer strategyType;
    public byte[] strategyParam;
    public Integer maxEntries;
    public Integer fileType;
    public LBAddr parentICBLocation;
    public Integer flags;
    public static final int LENGTH = 20;

    public ICBTag(byte[] byArray) throws InvalidICBTag {
        this.deserialize(byArray);
    }

    public void deserialize(byte[] byArray) throws InvalidICBTag {
        if (byArray.length < 20) {
            throw new InvalidICBTag("ICB tag too short");
        }
        this.priorEntryNum = UDFUtil.getUInt32(byArray, 0);
        this.strategyType = UDFUtil.getUInt16(byArray, 4);
        if (this.strategyType != 4) {
            throw new InvalidICBTag("Unsupported ICB strategy: " + this.strategyType);
        }
        this.strategyParam = UDFUtil.getBytes(byArray, 6, 2);
        this.maxEntries = UDFUtil.getUInt16(byArray, 8);
        this.fileType = UDFUtil.getUInt8(byArray, 11);
        byte[] byArray2 = UDFUtil.getBytes(byArray, 12, 6);
        try {
            this.parentICBLocation = new LBAddr(byArray2);
        }
        catch (InvalidLBAddr invalidLBAddr) {
            throw new InvalidICBTag(invalidLBAddr.getMessage());
        }
        this.flags = UDFUtil.getUInt16(byArray, 18);
    }

    public String toString() {
        return "ICBTag [priorEntryNum=" + this.priorEntryNum + ", strategyType=" + this.strategyType + ", strategyParam=" + new String(this.strategyParam, StandardCharsets.UTF_8).trim() + ", maxEntries=" + this.maxEntries + ", fileType=" + this.fileType + ", parentICBLocation=" + this.parentICBLocation + ", flags=" + this.flags + "]";
    }
}

