/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.math.BigInteger;

public class LogicalVolumeHeader {
    public BigInteger uniqueId;
    public byte[] reserved;
    public static final int LENGTH = 32;

    public LogicalVolumeHeader(byte[] byArray) throws InvalidDescriptor {
        this.deserialize(byArray);
    }

    private void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 32) {
            throw new InvalidDescriptor("RegId allocation descriptor too short");
        }
        this.uniqueId = UDFUtil.getUInt64(byArray, 0);
        this.reserved = UDFUtil.getBytes(byArray, 8, 24);
    }

    public String toString() {
        return "LogicalVolumeHeader [uniqueId=" + this.uniqueId + ", reserved=" + this.reserved + "]";
    }
}

