/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LBAddr;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLBAddr;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLongAD;
import java.nio.charset.StandardCharsets;

public class LongAD {
    public Long length;
    public LBAddr location;
    public byte[] implUse;
    public static final int LENGTH = 16;

    public LongAD(byte[] byArray) throws InvalidLongAD {
        this.deserialize(byArray);
    }

    public void deserialize(byte[] byArray) throws InvalidLongAD {
        if (byArray.length < 16) {
            throw new InvalidLongAD("long allocation descriptor too short");
        }
        this.length = UDFUtil.getUInt32(byArray, 0);
        byte[] byArray2 = UDFUtil.getBytes(byArray, 4, 6);
        try {
            this.location = new LBAddr(byArray2);
        }
        catch (InvalidLBAddr invalidLBAddr) {
            throw new InvalidLongAD(invalidLBAddr.getMessage());
        }
        this.implUse = UDFUtil.getBytes(byArray, 10, 6);
    }

    public String toString() {
        return "LongAD [length=" + this.length + ", location=" + this.location + ", implUse=" + new String(this.implUse, StandardCharsets.UTF_8).trim() + "]";
    }
}

