/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.util.Date;
import java.util.GregorianCalendar;

public class Timestamp {
    public Integer typeAndTimezone;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public int centiSeconds;
    public int hundredsofMicroseconds;
    public int microseconds;
    public static final int LENGTH = 12;

    public Timestamp(byte[] byArray) throws InvalidDescriptor {
        this.deserialize(byArray);
    }

    private void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 12) {
            throw new InvalidDescriptor("Timezone allocation descriptor too short");
        }
        this.typeAndTimezone = UDFUtil.getUInt16(byArray, 0);
        this.year = UDFUtil.getUInt16(byArray, 2);
        this.month = UDFUtil.getUInt8(byArray, 4);
        this.day = UDFUtil.getUInt8(byArray, 5);
        this.hour = UDFUtil.getUInt8(byArray, 6);
        this.minute = UDFUtil.getUInt8(byArray, 7);
        this.second = UDFUtil.getUInt8(byArray, 8);
        this.centiSeconds = UDFUtil.getUInt8(byArray, 9);
        this.hundredsofMicroseconds = UDFUtil.getUInt8(byArray, 10);
        this.microseconds = UDFUtil.getUInt8(byArray, 11);
    }

    public Date toDate() {
        return new GregorianCalendar(this.year, this.month - 1, this.day, this.hour, this.minute, this.second).getTime();
    }

    public String toString() {
        return "Timestamp [typeAndTimezone=" + this.typeAndTimezone + ", year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", centiSeconds=" + this.centiSeconds + ", hundredsofMicroseconds=" + this.hundredsofMicroseconds + ", microseconds=" + this.microseconds + "]";
    }
}

