/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.util.Arrays;

public class VolumeStructureDescriptor {
    public Integer structureType;
    public byte[] standardIdentifier;
    public Integer structureVersion;
    public byte[] structureData;
    public static final int LENGTH = 2048;

    public VolumeStructureDescriptor(byte[] byArray) throws InvalidDescriptor {
        this.deserialize(byArray);
    }

    private void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 2048) {
            throw new InvalidDescriptor("RegId allocation descriptor too short");
        }
        this.structureType = UDFUtil.getUInt8(byArray, 0);
        this.standardIdentifier = UDFUtil.getBytes(byArray, 1, 5);
        this.structureVersion = UDFUtil.getUInt8(byArray, 0);
    }

    public String toString() {
        return "VolumeStructureDescriptor [structureType=" + this.structureType + ", standardIdentifier=" + Arrays.toString(this.standardIdentifier) + ", structureVersion=" + this.structureVersion + "]";
    }
}

